/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tests;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.Description;

public class SuiteDescriptionTest {
    Description childless = Description.createSuiteDescription("a");
    Description anotherChildless = Description.createSuiteDescription("a");
    Description namedB = Description.createSuiteDescription("b");
    Description twoKids = this.descriptionWithTwoKids("foo", "bar");
    Description anotherTwoKids = this.descriptionWithTwoKids("foo", "baz");

    @Test
    public void equalsIsCorrect() {
        Assert.assertEquals(this.childless, this.anotherChildless);
        Assert.assertFalse(this.childless.equals(this.namedB));
        Assert.assertFalse(this.childless.equals(this.twoKids));
        Assert.assertFalse(this.twoKids.equals(this.anotherTwoKids));
        Assert.assertFalse(this.twoKids.equals(new Integer(5)));
    }

    @Test
    public void hashCodeIsReasonable() {
        Assert.assertEquals(this.childless.hashCode(), this.anotherChildless.hashCode());
        Assert.assertFalse(this.childless.hashCode() == this.namedB.hashCode());
    }

    private Description descriptionWithTwoKids(String first, String second) {
        Description twoKids = Description.createSuiteDescription("a");
        twoKids.addChild(Description.createTestDescription(this.getClass(), first));
        twoKids.addChild(Description.createTestDescription(this.getClass(), second));
        return twoKids;
    }
}

