/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tests;

import java.util.Collection;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runners.Parameterized;
import org.junit.runners.Suite;

public class SingleMethodTest {
    public static int count;

    @Test
    public void oneTimeSetup() throws Exception {
        count = 0;
        Runner runner = Request.method(OneTimeSetup.class, "one").getRunner();
        Result result = new JUnitCore().run(runner);
        Assert.assertEquals(1, count);
        Assert.assertEquals(1, result.getRunCount());
    }

    @Test
    public void parameterizedOneTimeSetup() throws Exception {
        count = 0;
        Runner runner = Request.method(ParameterizedOneTimeSetup.class, "one[0]").getRunner();
        Result result = new JUnitCore().run(runner);
        Assert.assertEquals(1, count);
        Assert.assertEquals(1, result.getRunCount());
    }

    @Test
    public void filteringAffectsPlan() throws Exception {
        Runner runner = Request.method(OneTimeSetup.class, "one").getRunner();
        Assert.assertEquals(1, runner.testCount());
    }

    @Test
    public void nonexistentMethodCreatesFailure() throws Exception {
        Assert.assertEquals(1, new JUnitCore().run(Request.method(OneTimeSetup.class, "thisMethodDontExist")).getFailureCount());
    }

    @Test(expected=NoTestsRemainException.class)
    public void filteringAwayEverythingThrowsException() throws NoTestsRemainException {
        Filterable runner = (Filterable)((Object)Request.aClass(OneTimeSetup.class).getRunner());
        runner.filter(new Filter(){

            public boolean shouldRun(Description description) {
                return false;
            }

            public String describe() {
                return null;
            }
        });
    }

    @Test
    public void eliminateUnnecessaryTreeBranches() throws Exception {
        Runner runner = Request.aClass(OneTwoSuite.class).filterWith(Description.createTestDescription(TestOne.class, "a")).getRunner();
        Description description = runner.getDescription();
        Assert.assertEquals(1, description.getChildren().size());
    }

    @RunWith(value=Suite.class)
    @Suite.SuiteClasses(value={TestOne.class, TestTwo.class})
    public static class OneTwoSuite {
    }

    public static class TestTwo {
        @Test
        public void a() {
        }

        @Test
        public void b() {
        }
    }

    public static class TestOne {
        @Test
        public void a() {
        }

        @Test
        public void b() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @RunWith(value=Parameterized.class)
    public static class ParameterizedOneTimeSetup {
        @Parameterized.Parameters
        public static Collection<Object[]> params() {
            return Parameterized.eachOne(1, 2);
        }

        public ParameterizedOneTimeSetup(int x) {
        }

        @BeforeClass
        public static void once() {
            ++count;
        }

        @Test
        public void one() {
        }
    }

    public static class OneTimeSetup {
        @BeforeClass
        public static void once() {
            ++count;
        }

        @Test
        public void one() {
        }

        @Test
        public void two() {
        }
    }
}

