/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tests;

import junit.framework.AssertionFailedError;
import junit.framework.JUnit4TestAdapter;
import junit.framework.TestListener;
import junit.framework.TestResult;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.runners.TestClassRunner;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;

public class InitializationErrorForwardCompatibilityTest {
    private JUnit4TestAdapter fAdapter;

    @Before
    public void createAdapter() {
        this.fAdapter = new JUnit4TestAdapter(CantInitializeTests.class);
    }

    @Test
    public void initializationErrorsShowUpAsWarnings() {
        Assert.assertEquals(1, this.fAdapter.getTests().size());
    }

    @Test
    public void initializationErrorsAreThrownAtRuntime() {
        TestResult result = new TestResult();
        this.fAdapter.run(result);
        Assert.assertEquals(1, result.errorCount());
        Assert.assertEquals("Unique error message", result.errors().nextElement().exceptionMessage());
    }

    @Test
    public void generatedErrorTestsMatchUp() {
        junit.framework.Test shouldFail = this.fAdapter.getTests().get(0);
        TestResult result = new TestResult();
        ErrorRememberingListener listener = new ErrorRememberingListener();
        result.addListener(listener);
        this.fAdapter.run(result);
        Assert.assertNotNull(listener.getError());
        Assert.assertTrue(shouldFail == listener.getError());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InitializesWithError
    extends TestClassRunner {
        public InitializesWithError(Class<?> klass) throws Exception {
            super(klass);
            throw new Exception();
        }
    }

    private final class ErrorRememberingListener
    implements TestListener {
        private junit.framework.Test fError;

        private ErrorRememberingListener() {
        }

        public void addError(junit.framework.Test test, Throwable t) {
            this.fError = test;
        }

        public void addFailure(junit.framework.Test test, AssertionFailedError t) {
        }

        public void endTest(junit.framework.Test test) {
        }

        public void startTest(junit.framework.Test test) {
        }

        public junit.framework.Test getError() {
            return this.fError;
        }
    }

    @RunWith(value=CantInitialize.class)
    public static class CantInitializeTests {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CantInitialize
    extends Runner {
        private static final String UNIQUE_ERROR_MESSAGE = "Unique error message";

        public CantInitialize(Class<?> klass) throws Exception {
            throw new Exception(UNIQUE_ERROR_MESSAGE);
        }

        @Override
        public Description getDescription() {
            return Description.EMPTY;
        }

        @Override
        public void run(RunNotifier notifier) {
        }
    }
}

