/*
 * Decompiled with CFR 0.152.
 */
package org.junit.samples;

import java.util.ArrayList;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import junit.textui.TestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class ListTest {
    protected List<Integer> fEmpty;
    protected List<Integer> fFull;
    protected static List<Integer> fgHeavy;

    public static void main(String ... args) {
        TestRunner.run(ListTest.suite());
    }

    @BeforeClass
    public static void setUpOnce() {
        fgHeavy = new ArrayList<Integer>();
        for (int i = 0; i < 1000; ++i) {
            fgHeavy.add(i);
        }
    }

    @Before
    public void setUp() {
        this.fEmpty = new ArrayList<Integer>();
        this.fFull = new ArrayList<Integer>();
        this.fFull.add(1);
        this.fFull.add(2);
        this.fFull.add(3);
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(ListTest.class);
    }

    @Ignore(value="not today")
    @Test
    public void capacity() {
        int size = this.fFull.size();
        for (int i = 0; i < 100; ++i) {
            this.fFull.add(i);
        }
        Assert.assertTrue(this.fFull.size() == 100 + size);
    }

    @Test
    public void testCopy() {
        ArrayList<Integer> copy = new ArrayList<Integer>(this.fFull.size());
        copy.addAll(this.fFull);
        Assert.assertTrue(copy.size() == this.fFull.size());
        Assert.assertTrue(copy.contains(1));
    }

    @Test
    public void contains() {
        Assert.assertTrue(this.fFull.contains(1));
        Assert.assertTrue(!this.fEmpty.contains(1));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void elementAt() {
        int i = this.fFull.get(0);
        Assert.assertTrue(i == 1);
        this.fFull.get(this.fFull.size());
    }

    @Test
    public void removeAll() {
        this.fFull.removeAll(this.fFull);
        this.fEmpty.removeAll(this.fEmpty);
        Assert.assertTrue(this.fFull.isEmpty());
        Assert.assertTrue(this.fEmpty.isEmpty());
    }

    @Test
    public void removeElement() {
        this.fFull.remove(new Integer(3));
        Assert.assertTrue(!this.fFull.contains(3));
    }
}

