/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.chronos.core.trigger;

import java.text.ParseException;
import java.util.Date;
import org.seasar.chronos.core.trigger.AbstractTrigger;
import org.seasar.chronos.core.trigger.cron.CronExpression;
import org.seasar.framework.exception.ParseRuntimeException;
import org.seasar.framework.log.Logger;

public class CCronTrigger
extends AbstractTrigger {
    private static Logger log = Logger.getLogger(CCronTrigger.class);
    private static final long serialVersionUID = 1L;
    private CronExpression expression;
    private Date buildTime = new Date(System.currentTimeMillis());

    public CCronTrigger() {
        super("cronTrigger");
    }

    public CCronTrigger(String cronExpression) {
        super("cronTrigger");
        this.setExpression(cronExpression);
    }

    public boolean isReScheduleTask() {
        return true;
    }

    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        CCronTrigger src = (CCronTrigger)obj;
        if (this.expression != null) {
            result &= this.expression.equals(src.expression);
        }
        return result;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String getCronExpression() {
        return this.expression.getCronExprssion();
    }

    public boolean isEndTask() {
        return false;
    }

    public boolean isStartTask() {
        Date nextValidTime;
        long nowTime = System.currentTimeMillis();
        if (nowTime > (nextValidTime = this.expression.getNextValidTimeAfter(this.buildTime)).getTime()) {
            this.buildTime = new Date(nowTime);
            return true;
        }
        return false;
    }

    public void setExpression(String cronExpression) {
        try {
            this.expression = new CronExpression(cronExpression);
        }
        catch (ParseException e) {
            log.log("ECHRONOS0200", null);
            throw new ParseRuntimeException(e);
        }
    }

    public String getExpression() {
        return this.expression.getCronExprssion();
    }

    public void setEndTask(boolean endTask) {
    }

    public void setExecute(boolean executed) {
    }

    public void setStartTask(boolean startTask) {
    }
}

