/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.BinaryQueryResponseWriter;
import org.apache.solr.request.QueryResponseWriter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.servlet.SolrRequestParsers;
import org.apache.solr.servlet.cache.HttpCacheHeaderUtil;
import org.apache.solr.servlet.cache.Method;

public class SolrDispatchFilter
implements Filter {
    final Logger log = Logger.getLogger(SolrDispatchFilter.class.getName());
    protected CoreContainer cores;
    protected String pathPrefix = null;
    protected String abortErrorMessage = null;
    protected String solrConfigFilename = null;
    protected final WeakHashMap<SolrCore, SolrRequestParsers> parsers = new WeakHashMap();

    public void init(FilterConfig config) throws ServletException {
        this.log.info("SolrDispatchFilter.init()");
        boolean abortOnConfigurationError = true;
        CoreContainer.Initializer init = this.createInitializer();
        try {
            this.pathPrefix = config.getInitParameter("path-prefix");
            init.setSolrConfigFilename(config.getInitParameter("solrconfig-filename"));
            this.cores = init.initialize();
            abortOnConfigurationError = init.isAbortOnConfigurationError();
            this.log.info("user.dir=" + System.getProperty("user.dir"));
        }
        catch (Throwable t) {
            this.log.log(Level.SEVERE, "Could not start SOLR. Check solr/home property", t);
            SolrConfig.severeErrors.add(t);
            SolrCore.log(t);
        }
        if (abortOnConfigurationError && SolrConfig.severeErrors.size() > 0) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            out.println("Severe errors in solr configuration.\n");
            out.println("Check your log files for more detailed information on what may be wrong.\n");
            out.println("If you want solr to continue after configuration errors, change: \n");
            out.println(" <abortOnConfigurationError>false</abortOnConfigurationError>\n");
            out.println("in " + init.getSolrConfigFilename() + "\n");
            for (Throwable t : SolrConfig.severeErrors) {
                out.println("-------------------------------------------------------------");
                t.printStackTrace(out);
            }
            out.flush();
            this.abortErrorMessage = sw.toString();
        }
        this.log.info("SolrDispatchFilter.init() done");
    }

    protected CoreContainer.Initializer createInitializer() {
        return new CoreContainer.Initializer();
    }

    public void destroy() {
        if (this.cores != null) {
            this.cores.shutdown();
            this.cores = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.abortErrorMessage != null) {
            ((HttpServletResponse)response).sendError(500, this.abortErrorMessage);
            return;
        }
        if (request instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            SolrRequestHandler handler = null;
            SolrQueryRequest solrReq = null;
            SolrCore core = null;
            String corename = "";
            try {
                int idx;
                String alternate;
                req.setAttribute("org.apache.solr.CoreContainer", (Object)this.cores);
                String path = req.getServletPath();
                if (req.getPathInfo() != null) {
                    path = path + req.getPathInfo();
                }
                if (this.pathPrefix != null && path.startsWith(this.pathPrefix)) {
                    path = path.substring(this.pathPrefix.length());
                }
                if ((alternate = this.cores.getManagementPath()) != null && path.startsWith(alternate)) {
                    path = path.substring(0, alternate.length());
                }
                if ((idx = path.indexOf(58)) > 0) {
                    path = path.substring(0, idx);
                }
                if (path.equals(this.cores.getAdminPath())) {
                    handler = this.cores.getMultiCoreHandler();
                    core = this.cores.getAdminCore();
                    if (core == null) {
                        throw new RuntimeException("Can not find a valid core for the cores admin handler");
                    }
                } else {
                    idx = path.indexOf("/", 1);
                    if (idx > 1 && (core = this.cores.getCore(corename = path.substring(1, idx))) != null) {
                        path = path.substring(idx);
                    }
                    if (core == null) {
                        corename = "";
                        core = this.cores.getCore("");
                    }
                }
                if (core != null) {
                    SolrConfig config = core.getSolrConfig();
                    SolrRequestParsers parser = null;
                    parser = this.parsers.get(core);
                    if (parser == null) {
                        parser = new SolrRequestParsers(config);
                        this.parsers.put(core, parser);
                    }
                    if (handler == null && path.length() > 1 && (handler = core.getRequestHandler(path)) == null && parser.isHandleSelect() && ("/select".equals(path) || "/select/".equals(path))) {
                        solrReq = parser.parse(core, path, req);
                        String qt = solrReq.getParams().get("qt");
                        if (qt != null && qt.startsWith("/")) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid query type.  Do not use /select to access: " + qt);
                        }
                        handler = core.getRequestHandler(qt);
                        if (handler == null) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown handler: " + qt);
                        }
                    }
                    if (handler != null) {
                        if (solrReq == null) {
                            solrReq = parser.parse(core, path, req);
                        }
                        Method reqMethod = Method.getMethod(req.getMethod());
                        HttpCacheHeaderUtil.setCacheControlHeader(config, resp, reqMethod);
                        if (config.getHttpCachingConfig().isNever304() || !HttpCacheHeaderUtil.doCacheHeaderValidation(solrReq, req, reqMethod, resp)) {
                            SolrQueryResponse solrRsp = new SolrQueryResponse();
                            this.execute(req, handler, solrReq, solrRsp);
                            HttpCacheHeaderUtil.checkHttpCachingVeto(solrRsp, resp, reqMethod);
                            if (solrRsp.getException() != null) {
                                this.sendError((HttpServletResponse)response, solrRsp.getException());
                            } else {
                                QueryResponseWriter responseWriter = core.getQueryResponseWriter(solrReq);
                                response.setContentType(responseWriter.getContentType(solrReq, solrRsp));
                                if (Method.HEAD != reqMethod) {
                                    if (responseWriter instanceof BinaryQueryResponseWriter) {
                                        BinaryQueryResponseWriter binWriter = (BinaryQueryResponseWriter)responseWriter;
                                        binWriter.write((OutputStream)response.getOutputStream(), solrReq, solrRsp);
                                    } else {
                                        PrintWriter out = response.getWriter();
                                        responseWriter.write(out, solrReq, solrRsp);
                                    }
                                }
                            }
                        }
                        return;
                    }
                    req.setAttribute("org.apache.solr.SolrCore", (Object)core);
                    if (path.startsWith("/admin")) {
                        req.getRequestDispatcher(this.pathPrefix == null ? path : this.pathPrefix + path).forward(request, response);
                        return;
                    }
                }
                this.log.fine("no handler or core retrieved for " + path + ", follow through...");
            }
            catch (Throwable ex) {
                this.sendError((HttpServletResponse)response, ex);
                return;
            }
            finally {
                if (solrReq != null) {
                    solrReq.close();
                }
                if (core != null) {
                    core.close();
                }
            }
        }
        chain.doFilter(request, response);
    }

    protected void execute(HttpServletRequest req, SolrRequestHandler handler, SolrQueryRequest sreq, SolrQueryResponse rsp) {
        sreq.getContext().put("webapp", req.getContextPath());
        sreq.getCore().execute(handler, sreq, rsp);
    }

    protected void sendError(HttpServletResponse res, Throwable ex) throws IOException {
        int code = 500;
        String trace = "";
        if (ex instanceof SolrException) {
            code = ((SolrException)ex).code();
        }
        if (code == 500 || code < 100) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            trace = "\n\n" + sw.toString();
            SolrException.logOnce((Logger)this.log, null, (Throwable)ex);
            if (code < 100) {
                this.log.warning("invalid return code: " + code);
                code = 500;
            }
        }
        res.sendError(code, ex.getMessage() + trace);
    }

    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }
}

