/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.ConstantScoreRangeQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.ConstantScorePrefixQuery;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrQueryParser;
import org.apache.solr.search.function.FunctionQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryParsing {
    public static final String OP = "q.op";
    public static final String V = "v";
    public static final String F = "f";
    public static final String TYPE = "type";
    public static final String DEFTYPE = "defType";
    public static final String LOCALPARAM_START = "{!";
    public static final char LOCALPARAM_END = '}';
    private static Pattern sortSep = Pattern.compile(",");

    public static Query parseQuery(String qs, IndexSchema schema) {
        return QueryParsing.parseQuery(qs, null, schema);
    }

    public static Query parseQuery(String qs, String defaultField, IndexSchema schema) {
        try {
            Query query = schema.getSolrQueryParser(defaultField).parse(qs);
            if (SolrCore.log.isLoggable(Level.FINEST)) {
                SolrCore.log.finest("After QueryParser:" + query);
            }
            return query;
        }
        catch (ParseException e) {
            SolrCore.log(e);
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error parsing Lucene query", (Throwable)e);
        }
    }

    public static Query parseQuery(String qs, String defaultField, SolrParams params, IndexSchema schema) {
        try {
            SolrQueryParser parser = schema.getSolrQueryParser(defaultField);
            String opParam = params.get(OP);
            if (opParam != null) {
                parser.setDefaultOperator("AND".equals(opParam) ? QueryParser.Operator.AND : QueryParser.Operator.OR);
            }
            Query query = parser.parse(qs);
            if (SolrCore.log.isLoggable(Level.FINEST)) {
                SolrCore.log.finest("After QueryParser:" + query);
            }
            return query;
        }
        catch (ParseException e) {
            SolrCore.log(e);
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Query parsing error: " + e.getMessage(), (Throwable)e);
        }
    }

    static int parseLocalParams(String txt, int start, Map<String, String> target, SolrParams params) throws ParseException {
        int off = start;
        if (!txt.startsWith(LOCALPARAM_START, off)) {
            return start;
        }
        StrParser p = new StrParser(txt, start, txt.length());
        p.pos += 2;
        char ch;
        while ((ch = p.peek()) != '}') {
            String id = p.getId();
            if (id.length() == 0) {
                throw new ParseException("Expected identifier '}' parsing local params '" + txt + '\"');
            }
            String val = null;
            ch = p.peek();
            if (ch != '=') {
                val = id;
                id = TYPE;
            } else {
                ++p.pos;
                ch = p.peek();
                if (ch == '\"' || ch == '\'') {
                    val = p.getQuotedString();
                } else if (ch == '$') {
                    ++p.pos;
                    String pname = p.getId();
                    if (params != null) {
                        val = params.get(pname);
                    }
                } else {
                    int valStart = p.pos;
                    while (true) {
                        if (p.pos >= p.end) {
                            throw new ParseException("Missing end to unquoted value starting at " + valStart + " str='" + txt + "'");
                        }
                        char c = p.val.charAt(p.pos);
                        if (c == '}' || Character.isWhitespace(c)) {
                            val = p.val.substring(valStart, p.pos);
                            break;
                        }
                        ++p.pos;
                    }
                }
            }
            if (target == null) continue;
            target.put(id, val);
        }
        return p.pos + 1;
    }

    public static SolrParams getLocalParams(String txt, SolrParams params) throws ParseException {
        String val;
        if (txt == null || !txt.startsWith(LOCALPARAM_START)) {
            return null;
        }
        HashMap<String, String> localParams = new HashMap<String, String>();
        int start = QueryParsing.parseLocalParams(txt, 0, localParams, params);
        val = start >= txt.length() ? ((val = (String)localParams.get(V)) == null ? "" : val) : txt.substring(start);
        localParams.put(V, val);
        return new MapSolrParams(localParams);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Sort parseSort(String sortSpec, IndexSchema schema) {
        if (sortSpec == null || sortSpec.length() == 0) {
            return null;
        }
        String[] parts = sortSep.split(sortSpec.trim());
        if (parts.length == 0) {
            return null;
        }
        SortField[] lst = new SortField[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i].trim();
            boolean top = true;
            int idx = part.indexOf(32);
            if (idx <= 0) throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing sort order.");
            String order = part.substring(idx + 1).trim();
            if ("desc".equals(order) || "top".equals(order)) {
                top = true;
            } else {
                if (!"asc".equals(order) && !"bottom".equals(order)) throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown sort order: " + order);
                top = false;
            }
            part = part.substring(0, idx).trim();
            if ("score".equals(part)) {
                if (top) {
                    if (parts.length == 1) {
                        return null;
                    }
                    lst[i] = SortField.FIELD_SCORE;
                    continue;
                }
                lst[i] = new SortField(null, 0, true);
                continue;
            }
            SchemaField f = null;
            try {
                f = schema.getField(part);
            }
            catch (SolrException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "can not sort on undefined field: " + part, (Throwable)e);
            }
            if (f == null || !f.indexed()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "can not sort on unindexed field: " + part);
            }
            lst[i] = f.getType().getSortField(f, top);
        }
        return new Sort(lst);
    }

    static FieldType writeFieldName(String name, IndexSchema schema, Appendable out, int flags) throws IOException {
        FieldType ft = null;
        ft = schema.getFieldTypeNoEx(name);
        out.append(name);
        if (ft == null) {
            out.append("(UNKNOWN FIELD " + name + ')');
        }
        out.append(':');
        return ft;
    }

    static void writeFieldVal(String val, FieldType ft, Appendable out, int flags) throws IOException {
        if (ft != null) {
            out.append(ft.toExternal((Fieldable)new Field("", val, Field.Store.YES, Field.Index.UN_TOKENIZED)));
        } else {
            out.append(val);
        }
    }

    public static void toString(Query query, IndexSchema schema, Appendable out, int flags) throws IOException {
        boolean writeBoost = true;
        if (query instanceof TermQuery) {
            TermQuery q = (TermQuery)query;
            Term t = q.getTerm();
            FieldType ft = QueryParsing.writeFieldName(t.field(), schema, out, flags);
            QueryParsing.writeFieldVal(t.text(), ft, out, flags);
        } else if (query instanceof RangeQuery) {
            RangeQuery q = (RangeQuery)query;
            String fname = q.getField();
            FieldType ft = QueryParsing.writeFieldName(fname, schema, out, flags);
            out.append(q.isInclusive() ? (char)'[' : '{');
            Term lt = q.getLowerTerm();
            Term ut = q.getUpperTerm();
            if (lt == null) {
                out.append('*');
            } else {
                QueryParsing.writeFieldVal(lt.text(), ft, out, flags);
            }
            out.append(" TO ");
            if (ut == null) {
                out.append('*');
            } else {
                QueryParsing.writeFieldVal(ut.text(), ft, out, flags);
            }
            out.append(q.isInclusive() ? (char)']' : '}');
        } else if (query instanceof ConstantScoreRangeQuery) {
            ConstantScoreRangeQuery q = (ConstantScoreRangeQuery)query;
            String fname = q.getField();
            FieldType ft = QueryParsing.writeFieldName(fname, schema, out, flags);
            out.append(q.includesLower() ? (char)'[' : '{');
            String lt = q.getLowerVal();
            String ut = q.getUpperVal();
            if (lt == null) {
                out.append('*');
            } else {
                QueryParsing.writeFieldVal(lt, ft, out, flags);
            }
            out.append(" TO ");
            if (ut == null) {
                out.append('*');
            } else {
                QueryParsing.writeFieldVal(ut, ft, out, flags);
            }
            out.append(q.includesUpper() ? (char)']' : '}');
        } else if (query instanceof BooleanQuery) {
            BooleanQuery q = (BooleanQuery)query;
            boolean needParens = false;
            if ((double)q.getBoost() != 1.0 || q.getMinimumNumberShouldMatch() != 0) {
                needParens = true;
            }
            if (needParens) {
                out.append('(');
            }
            boolean first = true;
            for (BooleanClause c : q.clauses()) {
                if (!first) {
                    out.append(' ');
                } else {
                    first = false;
                }
                if (c.isProhibited()) {
                    out.append('-');
                } else if (c.isRequired()) {
                    out.append('+');
                }
                Query subQuery = c.getQuery();
                boolean wrapQuery = false;
                if (subQuery instanceof BooleanQuery) {
                    wrapQuery = true;
                }
                if (wrapQuery) {
                    out.append('(');
                }
                QueryParsing.toString(subQuery, schema, out, flags);
                if (!wrapQuery) continue;
                out.append(')');
            }
            if (needParens) {
                out.append(')');
            }
            if (q.getMinimumNumberShouldMatch() > 0) {
                out.append('~');
                out.append(Integer.toString(q.getMinimumNumberShouldMatch()));
            }
        } else if (query instanceof PrefixQuery) {
            PrefixQuery q = (PrefixQuery)query;
            Term prefix = q.getPrefix();
            FieldType ft = QueryParsing.writeFieldName(prefix.field(), schema, out, flags);
            out.append(prefix.text());
            out.append('*');
        } else if (query instanceof ConstantScorePrefixQuery) {
            ConstantScorePrefixQuery q = (ConstantScorePrefixQuery)query;
            Term prefix = q.getPrefix();
            FieldType ft = QueryParsing.writeFieldName(prefix.field(), schema, out, flags);
            out.append(prefix.text());
            out.append('*');
        } else if (query instanceof WildcardQuery) {
            out.append(query.toString());
            writeBoost = false;
        } else if (query instanceof FuzzyQuery) {
            out.append(query.toString());
            writeBoost = false;
        } else if (query instanceof ConstantScoreQuery) {
            out.append(query.toString());
            writeBoost = false;
        } else {
            out.append(query.getClass().getSimpleName() + '(' + query.toString() + ')');
            writeBoost = false;
        }
        if (writeBoost && query.getBoost() != 1.0f) {
            out.append("^");
            out.append(Float.toString(query.getBoost()));
        }
    }

    public static String toString(Query query, IndexSchema schema) {
        try {
            StringBuilder sb = new StringBuilder();
            QueryParsing.toString(query, schema, sb, 0);
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> toString(List<Query> queries, IndexSchema schema) {
        ArrayList<String> out = new ArrayList<String>(queries.size());
        for (Query q : queries) {
            out.add(QueryParsing.toString(q, schema));
        }
        return out;
    }

    public static FunctionQuery parseFunction(String func, IndexSchema schema) throws ParseException {
        SolrCore core = SolrCore.getSolrCore();
        return (FunctionQuery)QParser.getParser(func, "func", new LocalSolrQueryRequest(core, new HashMap<String, String[]>())).parse();
    }

    static class StrParser {
        String val;
        int pos;
        int end;

        StrParser(String val) {
            this(val, 0, val.length());
        }

        StrParser(String val, int start, int end) {
            this.val = val;
            this.pos = start;
            this.end = end;
        }

        void eatws() {
            while (this.pos < this.end && Character.isWhitespace(this.val.charAt(this.pos))) {
                ++this.pos;
            }
        }

        void skip(int nChars) {
            this.pos = Math.max(this.pos + nChars, this.end);
        }

        boolean opt(String s) {
            this.eatws();
            int slen = s.length();
            if (this.val.regionMatches(this.pos, s, 0, slen)) {
                this.pos += slen;
                return true;
            }
            return false;
        }

        boolean opt(char ch) {
            this.eatws();
            if (this.val.charAt(this.pos) == ch) {
                ++this.pos;
                return true;
            }
            return false;
        }

        void expect(String s) throws ParseException {
            this.eatws();
            int slen = s.length();
            if (this.val.regionMatches(this.pos, s, 0, slen)) {
                this.pos += slen;
            } else {
                throw new ParseException("Expected '" + s + "' at position " + this.pos + " in '" + this.val + "'");
            }
        }

        float getFloat() throws ParseException {
            char ch;
            int i;
            this.eatws();
            char[] arr = new char[this.end - this.pos];
            for (i = 0; i < arr.length && ((ch = this.val.charAt(this.pos)) >= '0' && ch <= '9' || ch == '+' || ch == '-' || ch == '.' || ch == 'e' || ch == 'E'); ++i) {
                ++this.pos;
                arr[i] = ch;
            }
            return Float.parseFloat(new String(arr, 0, i));
        }

        String getId() throws ParseException {
            this.eatws();
            int id_start = this.pos;
            if (this.pos < this.end && Character.isJavaIdentifierStart(this.val.charAt(this.pos))) {
                char ch;
                ++this.pos;
                while (this.pos < this.end && (Character.isJavaIdentifierPart(ch = this.val.charAt(this.pos)) || ch == '.')) {
                    ++this.pos;
                }
                return this.val.substring(id_start, this.pos);
            }
            throw new ParseException("Expected identifier at pos " + this.pos + " str='" + this.val + "'");
        }

        String getQuotedString() throws ParseException {
            this.eatws();
            char delim = this.peekChar();
            if (delim != '\"' && delim != '\'') {
                return null;
            }
            int val_start = ++this.pos;
            StringBuilder sb = new StringBuilder();
            while (true) {
                if (this.pos >= this.end) {
                    throw new ParseException("Missing end quote for string at pos " + (val_start - 1) + " str='" + this.val + "'");
                }
                char ch = this.val.charAt(this.pos);
                if (ch == '\\') {
                    ch = this.pos < this.end ? this.val.charAt(this.pos++) : (char)'\u0000';
                } else if (ch == delim) {
                    ++this.pos;
                    return sb.toString();
                }
                sb.append(ch);
                ++this.pos;
            }
        }

        char peek() {
            this.eatws();
            return this.pos < this.end ? this.val.charAt(this.pos) : (char)'\u0000';
        }

        char peekChar() {
            return this.pos < this.end ? this.val.charAt(this.pos) : (char)'\u0000';
        }

        public String toString() {
            return "'" + this.val + "'" + ", pos=" + this.pos;
        }
    }
}

