/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.SortField;
import org.apache.solr.analysis.SolrAnalyzer;
import org.apache.solr.common.SolrException;
import org.apache.solr.request.TextResponseWriter;
import org.apache.solr.request.XMLWriter;
import org.apache.solr.schema.FieldProperties;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.Sorting;
import org.apache.solr.search.function.OrdFieldSource;
import org.apache.solr.search.function.ValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldType
extends FieldProperties {
    public static final Logger log = Logger.getLogger(FieldType.class.getName());
    protected String typeName;
    protected Map<String, String> args;
    protected int trueProperties;
    protected int falseProperties;
    int properties;
    protected Analyzer analyzer;
    protected Analyzer queryAnalyzer;

    public FieldType() {
        this.queryAnalyzer = this.analyzer = new DefaultAnalyzer(256);
    }

    public boolean isTokenized() {
        return (this.properties & 2) != 0;
    }

    protected void init(IndexSchema schema, Map<String, String> args) {
    }

    protected String getArg(String n, Map<String, String> args) {
        String s = args.remove(n);
        if (s == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing parameter '" + n + "' for FieldType=" + this.typeName + args);
        }
        return s;
    }

    void setArgs(IndexSchema schema, Map<String, String> args) {
        this.properties = 5;
        if (schema.getVersion() < 1.1f) {
            this.properties |= 0x200;
        }
        this.args = args;
        HashMap<String, String> initArgs = new HashMap<String, String>(args);
        this.trueProperties = FieldProperties.parseProperties(initArgs, true);
        this.falseProperties = FieldProperties.parseProperties(initArgs, false);
        this.properties &= ~this.falseProperties;
        this.properties |= this.trueProperties;
        for (String prop : FieldProperties.propertyNames) {
            initArgs.remove(prop);
        }
        this.init(schema, initArgs);
        String positionInc = (String)initArgs.get("positionIncrementGap");
        if (positionInc != null) {
            Analyzer analyzer = this.getAnalyzer();
            if (!(analyzer instanceof SolrAnalyzer)) {
                throw new RuntimeException("Can't set positionIncrementGap on custom analyzer " + analyzer.getClass());
            }
            ((SolrAnalyzer)analyzer).setPositionIncrementGap(Integer.parseInt(positionInc));
            analyzer = this.getQueryAnalyzer();
            if (!(analyzer instanceof SolrAnalyzer)) {
                throw new RuntimeException("Can't set positionIncrementGap on custom analyzer " + analyzer.getClass());
            }
            ((SolrAnalyzer)analyzer).setPositionIncrementGap(Integer.parseInt(positionInc));
            initArgs.remove("positionIncrementGap");
        }
        if (initArgs.size() > 0) {
            throw new RuntimeException("schema fieldtype " + this.typeName + "(" + this.getClass().getName() + ")" + " invalid arguments:" + initArgs);
        }
    }

    protected void restrictProps(int props) {
        if ((this.properties & props) != 0) {
            throw new RuntimeException("schema fieldtype " + this.typeName + "(" + this.getClass().getName() + ")" + " invalid properties:" + FieldType.propertiesToString(this.properties & props));
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String toString() {
        return this.typeName + "{class=" + this.getClass().getName() + (this.analyzer != null ? ",analyzer=" + this.analyzer.getClass().getName() : "") + ",args=" + this.args + "}";
    }

    public Field createField(SchemaField field, String externalVal, float boost) {
        String val;
        try {
            val = this.toInternal(externalVal);
        }
        catch (NumberFormatException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error while creating field '" + field + "' from value '" + externalVal + "'", (Throwable)e, false);
        }
        if (val == null) {
            return null;
        }
        if (!field.indexed() && !field.stored()) {
            log.finest("Ignoring unindexed/unstored field: " + field);
            return null;
        }
        Field f = new Field(field.getName(), val, this.getFieldStore(field, val), this.getFieldIndex(field, val), this.getFieldTermVec(field, val));
        f.setOmitNorms(field.omitNorms());
        f.setBoost(boost);
        return f;
    }

    protected Field.TermVector getFieldTermVec(SchemaField field, String internalVal) {
        Field.TermVector ftv = Field.TermVector.NO;
        if (field.storeTermPositions() && field.storeTermOffsets()) {
            ftv = Field.TermVector.WITH_POSITIONS_OFFSETS;
        } else if (field.storeTermPositions()) {
            ftv = Field.TermVector.WITH_POSITIONS;
        } else if (field.storeTermOffsets()) {
            ftv = Field.TermVector.WITH_OFFSETS;
        } else if (field.storeTermVector()) {
            ftv = Field.TermVector.YES;
        }
        return ftv;
    }

    protected Field.Store getFieldStore(SchemaField field, String internalVal) {
        return field.stored() ? Field.Store.YES : Field.Store.NO;
    }

    protected Field.Index getFieldIndex(SchemaField field, String internalVal) {
        return field.indexed() ? (this.isTokenized() ? Field.Index.TOKENIZED : Field.Index.UN_TOKENIZED) : Field.Index.NO;
    }

    public String toInternal(String val) {
        return val;
    }

    public String toExternal(Fieldable f) {
        return f.stringValue();
    }

    public Object toObject(Fieldable f) {
        return this.toExternal(f);
    }

    public String indexedToReadable(String indexedForm) {
        return indexedForm;
    }

    public String storedToReadable(Fieldable f) {
        return this.toExternal(f);
    }

    public String storedToIndexed(Fieldable f) {
        return f.stringValue();
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Analyzer getQueryAnalyzer() {
        return this.queryAnalyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
        log.finest("FieldType: " + this.typeName + ".setAnalyzer(" + analyzer.getClass().getName() + ")");
    }

    public void setQueryAnalyzer(Analyzer analyzer) {
        this.queryAnalyzer = analyzer;
        log.finest("FieldType: " + this.typeName + ".setQueryAnalyzer(" + analyzer.getClass().getName() + ")");
    }

    public abstract void write(XMLWriter var1, String var2, Fieldable var3) throws IOException;

    public abstract void write(TextResponseWriter var1, String var2, Fieldable var3) throws IOException;

    public abstract SortField getSortField(SchemaField var1, boolean var2);

    protected SortField getStringSort(SchemaField field, boolean reverse) {
        return Sorting.getStringSortField(field.name, reverse, field.sortMissingLast(), field.sortMissingFirst());
    }

    public ValueSource getValueSource(SchemaField field, QParser parser) {
        return this.getValueSource(field);
    }

    @Deprecated
    public ValueSource getValueSource(SchemaField field) {
        return new OrdFieldSource(field.name);
    }

    protected final class DefaultAnalyzer
    extends SolrAnalyzer {
        final int maxChars;

        DefaultAnalyzer(int maxChars) {
            this.maxChars = maxChars;
        }

        public TokenStream tokenStream(String fieldName, Reader reader) {
            return new Tokenizer(reader){
                char[] cbuf;
                {
                    this.cbuf = new char[DefaultAnalyzer.this.maxChars];
                }

                public Token next() throws IOException {
                    int n = this.input.read(this.cbuf, 0, DefaultAnalyzer.this.maxChars);
                    if (n <= 0) {
                        return null;
                    }
                    String s = FieldType.this.toInternal(new String(this.cbuf, 0, n));
                    return new Token(s, 0, n);
                }
            };
        }
    }
}

