/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import javax.xml.xpath.XPathConstants;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SpanScorer;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.search.highlight.TokenSources;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.Config;
import org.apache.solr.highlight.GapFragmenter;
import org.apache.solr.highlight.HtmlFormatter;
import org.apache.solr.highlight.SolrFormatter;
import org.apache.solr.highlight.SolrFragmenter;
import org.apache.solr.highlight.SolrHighlighter;
import org.apache.solr.highlight.TokenOrderingFilter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.plugin.NamedListPluginLoader;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSolrHighlighter
extends SolrHighlighter {
    @Override
    public void initalize(Config config) {
        this.formatters.clear();
        this.fragmenters.clear();
        String xpath = "highlighting/fragmenter";
        NamedListPluginLoader fragloader = new NamedListPluginLoader(xpath, this.fragmenters);
        SolrFragmenter frag = (SolrFragmenter)fragloader.load(config.getResourceLoader(), (NodeList)config.evaluate(xpath, XPathConstants.NODESET));
        if (frag == null) {
            frag = new GapFragmenter();
        }
        this.fragmenters.put("", frag);
        this.fragmenters.put(null, frag);
        xpath = "highlighting/formatter";
        NamedListPluginLoader fmtloader = new NamedListPluginLoader(xpath, this.formatters);
        SolrFormatter fmt = (SolrFormatter)fmtloader.load(config.getResourceLoader(), (NodeList)config.evaluate(xpath, XPathConstants.NODESET));
        if (fmt == null) {
            fmt = new HtmlFormatter();
        }
        this.formatters.put("", fmt);
        this.formatters.put(null, fmt);
    }

    protected Highlighter getPhraseHighlighter(Query query, String fieldName, SolrQueryRequest request, CachingTokenFilter tokenStream) throws IOException {
        SolrParams params = request.getParams();
        Highlighter highlighter = null;
        highlighter = new Highlighter(this.getFormatter(fieldName, params), (Scorer)this.getSpanQueryScorer(query, fieldName, tokenStream, request));
        highlighter.setTextFragmenter(this.getFragmenter(fieldName, params));
        return highlighter;
    }

    protected Highlighter getHighlighter(Query query, String fieldName, SolrQueryRequest request) {
        SolrParams params = request.getParams();
        Highlighter highlighter = new Highlighter(this.getFormatter(fieldName, params), (Scorer)this.getQueryScorer(query, fieldName, request));
        highlighter.setTextFragmenter(this.getFragmenter(fieldName, params));
        return highlighter;
    }

    private SpanScorer getSpanQueryScorer(Query query, String fieldName, CachingTokenFilter tokenStream, SolrQueryRequest request) throws IOException {
        boolean reqFieldMatch = request.getParams().getFieldBool(fieldName, "hl.requireFieldMatch", false);
        if (reqFieldMatch) {
            return new SpanScorer(query, fieldName, tokenStream);
        }
        return new SpanScorer(query, null, tokenStream);
    }

    protected QueryScorer getQueryScorer(Query query, String fieldName, SolrQueryRequest request) {
        boolean reqFieldMatch = request.getParams().getFieldBool(fieldName, "hl.requireFieldMatch", false);
        if (reqFieldMatch) {
            return new QueryScorer(query, request.getSearcher().getReader(), fieldName);
        }
        return new QueryScorer(query);
    }

    protected int getMaxSnippets(String fieldName, SolrParams params) {
        return params.getFieldInt(fieldName, "hl.snippets", 1);
    }

    protected boolean isMergeContiguousFragments(String fieldName, SolrParams params) {
        return params.getFieldBool(fieldName, "hl.mergeContiguous", false);
    }

    protected Formatter getFormatter(String fieldName, SolrParams params) {
        String str = params.getFieldParam(fieldName, "hl.formatter");
        SolrFormatter formatter = (SolrFormatter)this.formatters.get(str);
        if (formatter == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown formatter: " + str);
        }
        return formatter.getFormatter(fieldName, params);
    }

    protected Fragmenter getFragmenter(String fieldName, SolrParams params) {
        String fmt = params.getFieldParam(fieldName, "hl.fragmenter");
        SolrFragmenter frag = (SolrFragmenter)this.fragmenters.get(fmt);
        if (frag == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown fragmenter: " + fmt);
        }
        return frag.getFragmenter(fieldName, params);
    }

    @Override
    public NamedList<Object> doHighlighting(DocList docs, Query query, SolrQueryRequest req, String[] defaultFields) throws IOException {
        SolrParams params = req.getParams();
        if (!this.isHighlightingEnabled(params)) {
            return null;
        }
        SolrIndexSearcher searcher = req.getSearcher();
        IndexSchema schema = searcher.getSchema();
        SimpleOrderedMap fragments = new SimpleOrderedMap();
        String[] fieldNames = this.getHighlightFields(query, req, defaultFields);
        Document[] readDocs = new Document[docs.size()];
        HashSet<String> fset = new HashSet<String>();
        for (String f : fieldNames) {
            fset.add(f);
        }
        SchemaField keyField = schema.getUniqueKeyField();
        if (null != keyField) {
            fset.add(keyField.getName());
        }
        searcher.readDocs(readDocs, docs, fset);
        DocIterator iterator = docs.iterator();
        for (int i = 0; i < docs.size(); ++i) {
            int docId = iterator.nextDoc();
            Document doc = readDocs[i];
            SimpleOrderedMap docSummaries = new SimpleOrderedMap();
            for (String fieldName : fieldNames) {
                String[] altTexts;
                String alternateField;
                String[] docTexts = doc.getValues(fieldName = fieldName.trim());
                if (docTexts == null) continue;
                Object tstream = null;
                int numFragments = this.getMaxSnippets(fieldName, params);
                boolean mergeContiguousFragments = this.isMergeContiguousFragments(fieldName, params);
                String[] summaries = null;
                ArrayList<TextFragment> frags = new ArrayList<TextFragment>();
                for (int j = 0; j < docTexts.length; ++j) {
                    Highlighter highlighter;
                    try {
                        tstream = TokenSources.getTokenStream((IndexReader)searcher.getReader(), (int)docId, (String)fieldName);
                    }
                    catch (IllegalArgumentException e) {
                        tstream = new TokenOrderingFilter(schema.getAnalyzer().tokenStream(fieldName, (Reader)new StringReader(docTexts[j])), 10);
                    }
                    if (Boolean.valueOf(req.getParams().get("hl.usePhraseHighlighter")).booleanValue()) {
                        tstream = new CachingTokenFilter(tstream);
                        highlighter = this.getPhraseHighlighter(query, fieldName, req, (CachingTokenFilter)tstream);
                        tstream.reset();
                    } else {
                        highlighter = this.getHighlighter(query, fieldName, req);
                    }
                    int maxCharsToAnalyze = params.getFieldInt(fieldName, "hl.maxAnalyzedChars", 51200);
                    if (maxCharsToAnalyze < 0) {
                        highlighter.setMaxDocCharsToAnalyze(docTexts[j].length());
                    } else {
                        highlighter.setMaxDocCharsToAnalyze(maxCharsToAnalyze);
                    }
                    TextFragment[] bestTextFragments = highlighter.getBestTextFragments(tstream, docTexts[j], mergeContiguousFragments, numFragments);
                    for (int k = 0; k < bestTextFragments.length; ++k) {
                        if (bestTextFragments[k] == null || !(bestTextFragments[k].getScore() > 0.0f)) continue;
                        frags.add(bestTextFragments[k]);
                    }
                }
                Collections.sort(frags, new Comparator<TextFragment>(){

                    @Override
                    public int compare(TextFragment arg0, TextFragment arg1) {
                        return Math.round(arg1.getScore() - arg0.getScore());
                    }
                });
                if (frags.size() > 0) {
                    ArrayList<String> fragTexts = new ArrayList<String>();
                    for (TextFragment fragment : frags) {
                        if (fragment != null && fragment.getScore() > 0.0f) {
                            fragTexts.add(fragment.toString());
                        }
                        if (fragTexts.size() < numFragments) continue;
                        break;
                    }
                    if ((summaries = fragTexts.toArray(new String[0])).length > 0) {
                        docSummaries.add(fieldName, (Object)summaries);
                    }
                }
                if (summaries != null && summaries.length != 0 || (alternateField = req.getParams().getFieldParam(fieldName, "hl.alternateField")) == null || alternateField.length() <= 0 || (altTexts = doc.getValues(alternateField)) == null || altTexts.length <= 0) continue;
                int alternateFieldLen = req.getParams().getFieldInt(fieldName, "hl.maxAlternateFieldLength", 0);
                if (alternateFieldLen <= 0) {
                    docSummaries.add(fieldName, (Object)altTexts);
                    continue;
                }
                ArrayList<String> altList = new ArrayList<String>();
                int len = 0;
                for (String altText : altTexts) {
                    altList.add(len + altText.length() > alternateFieldLen ? altText.substring(0, alternateFieldLen - len) : altText);
                    if ((len += altText.length()) >= alternateFieldLen) break;
                }
                docSummaries.add(fieldName, altList);
            }
            String printId = schema.printableUniqueKey(doc);
            fragments.add(printId == null ? null : printId, (Object)docSummaries);
        }
        return fragments;
    }
}

