/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.util.plugin.ResourceLoaderAware;

public class StopFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    private Set stopWords;
    private boolean ignoreCase;
    private boolean enablePositionIncrements;

    public void inform(ResourceLoader loader) {
        String stopWordFiles = (String)this.args.get("words");
        this.ignoreCase = this.getBoolean("ignoreCase", false);
        this.enablePositionIncrements = this.getBoolean("enablePositionIncrements", false);
        if (stopWordFiles != null) {
            if (this.stopWords == null) {
                this.stopWords = new HashSet();
            }
            try {
                File keepWordsFile = new File(stopWordFiles);
                if (keepWordsFile.exists()) {
                    List wlist = loader.getLines(stopWordFiles);
                    this.stopWords = StopFilter.makeStopSet((String[])wlist.toArray(new String[0]), (boolean)this.ignoreCase);
                }
                List files = StrUtils.splitFileNames((String)stopWordFiles);
                for (String file : files) {
                    List wlist = loader.getLines(file.trim());
                    this.stopWords.addAll(StopFilter.makeStopSet((String[])wlist.toArray(new String[0]), (boolean)this.ignoreCase));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.stopWords = StopFilter.makeStopSet((String[])StopAnalyzer.ENGLISH_STOP_WORDS, (boolean)this.ignoreCase);
        }
    }

    public boolean isEnablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public Set getStopWords() {
        return this.stopWords;
    }

    public StopFilter create(TokenStream input) {
        StopFilter stopFilter = new StopFilter(input, this.stopWords, this.ignoreCase);
        stopFilter.setEnablePositionIncrements(this.enablePositionIncrements);
        return stopFilter;
    }
}

