/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.nio.CharBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public final class PatternReplaceFilter
extends TokenFilter {
    Pattern p;
    String replacement;
    boolean all = true;

    public PatternReplaceFilter(TokenStream in, Pattern p, String replacement, boolean all) {
        super(in);
        this.p = p;
        this.replacement = null == replacement ? "" : replacement;
        this.all = all;
    }

    public final Token next(Token in) throws IOException {
        Token t = this.input.next(in);
        if (t == null) {
            return null;
        }
        CharBuffer text = CharBuffer.wrap(t.termBuffer(), 0, t.termLength());
        Matcher m = this.p.matcher(text);
        if (this.all) {
            t.setTermText(m.replaceAll(this.replacement));
        } else {
            t.setTermText(m.replaceFirst(this.replacement));
        }
        return t;
    }
}

