/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.dataimport.ContextImpl;
import org.apache.solr.handler.dataimport.DataConfig;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.DebugLogger;
import org.apache.solr.handler.dataimport.EntityProcessor;
import org.apache.solr.handler.dataimport.EvaluatorBag;
import org.apache.solr.handler.dataimport.SolrWriter;
import org.apache.solr.handler.dataimport.SqlEntityProcessor;
import org.apache.solr.handler.dataimport.VariableResolverImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocBuilder {
    public static final String DOC_BOOST = "$docBoost";
    private static final Logger LOG = Logger.getLogger(DocBuilder.class.getName());
    private DataImporter dataImporter;
    private DataConfig.Document document;
    private DataConfig.Entity root;
    private Map statusMessages = new LinkedHashMap();
    public Statistics importStatistics = new Statistics();
    SolrWriter writer;
    DataImporter.RequestParams requestParameters;
    boolean verboseDebug = false;
    private Map<String, String> defaultVariables;
    private Map<String, Object> session = new HashMap<String, Object>();
    static final ThreadLocal<DocBuilder> INSTANCE = new ThreadLocal();
    private AtomicBoolean stop = new AtomicBoolean(false);
    public static final String TIME_ELAPSED = "Time Elapsed";
    public static final String LAST_INDEX_TIME = "last_index_time";
    public static final String INDEX_START_TIME = "index_start_time";

    public DocBuilder(DataImporter context, SolrWriter writer, DataImporter.RequestParams reqParams, Map<String, String> variables) {
        INSTANCE.set(this);
        this.dataImporter = context;
        this.writer = writer;
        DataImporter.QUERY_COUNT.set(this.importStatistics.queryCount);
        this.requestParameters = reqParams;
        this.verboseDebug = this.requestParameters.debug && this.requestParameters.verbose;
        this.defaultVariables = Collections.unmodifiableMap(variables);
    }

    public VariableResolverImpl getVariableResolver(DataImporter context) {
        VariableResolverImpl resolver = new VariableResolverImpl();
        HashMap<String, Object> indexerNamespace = new HashMap<String, Object>();
        if (context.getLastIndexTime() != null) {
            indexerNamespace.put(LAST_INDEX_TIME, DataImporter.DATE_TIME_FORMAT.format(context.getLastIndexTime()));
        }
        indexerNamespace.put(INDEX_START_TIME, context.getIndexStartTime());
        indexerNamespace.put("request", this.requestParameters);
        indexerNamespace.put("defaults", this.defaultVariables);
        indexerNamespace.put("functions", EvaluatorBag.getFunctionsNamespace(resolver, this.dataImporter.getConfig().evaluators));
        if (context.getConfig().script != null) {
            indexerNamespace.put("script", context.getConfig().script.script);
            indexerNamespace.put("scriptlanguage", context.getConfig().script.language);
        }
        resolver.addNamespace("dataimporter", indexerNamespace);
        return resolver;
    }

    public void execute(String docName) {
        this.dataImporter.store("status-messages", this.statusMessages);
        this.document = this.dataImporter.getConfig().getDocumentByName(docName);
        if (this.document == null) {
            return;
        }
        final AtomicLong startTime = new AtomicLong(System.currentTimeMillis());
        this.statusMessages.put(TIME_ELAPSED, new Object(){

            public String toString() {
                return DocBuilder.getTimeElapsedSince(startTime.get());
            }
        });
        this.statusMessages.put("Total Requests made to DataSource", this.importStatistics.queryCount);
        this.statusMessages.put("Total Rows Fetched", this.importStatistics.rowsCount);
        this.statusMessages.put("Total Documents Processed", this.importStatistics.docCount);
        this.statusMessages.put("Total Documents Skipped", this.importStatistics.skipDocCount);
        List<String> entities = this.requestParameters.entities;
        for (DataConfig.Entity e : this.document.entities) {
            if (entities != null && !entities.contains(e.name)) continue;
            this.root = e;
            if (this.dataImporter.getStatus() == DataImporter.Status.RUNNING_DELTA_DUMP && this.dataImporter.getLastIndexTime() != null) {
                this.doDelta();
            } else {
                this.doFullDump();
            }
            this.statusMessages.remove("Total Documents Processed");
        }
        if (this.stop.get()) {
            if ("abort".equals(this.requestParameters.command)) {
                this.statusMessages.put("Aborted", DataImporter.DATE_TIME_FORMAT.format(new Date()));
            } else if (this.requestParameters.commit) {
                this.commit();
            }
        } else {
            this.commit();
        }
        this.statusMessages.remove(TIME_ELAPSED);
        this.statusMessages.put("Time taken ", DocBuilder.getTimeElapsedSince(startTime.get()));
        LOG.info("Time taken = " + DocBuilder.getTimeElapsedSince(startTime.get()));
    }

    private void commit() {
        if (this.requestParameters.commit) {
            this.writer.persistIndexStartTime(this.dataImporter.getIndexStartTime());
        }
        LOG.info("Full Import completed successfully");
        this.statusMessages.put("", "Indexing completed. Added/Updated: " + this.importStatistics.docCount + " documents. Deleted " + this.importStatistics.deletedDocCount + " documents.");
        this.writer.commit(this.requestParameters.optimize);
        this.addStatusMessage("Committed");
        if (this.requestParameters.optimize) {
            this.addStatusMessage("Optimized");
        }
    }

    private void doFullDump() {
        this.addStatusMessage("Full Dump Started");
        this.buildDocument(this.getVariableResolver(this.dataImporter), null, null, this.root, true, null);
    }

    private void doDelta() {
        this.addStatusMessage("Delta Dump started");
        VariableResolverImpl resolver = this.getVariableResolver(this.dataImporter);
        if (this.document.deleteQuery != null) {
            this.writer.deleteByQuery(this.document.deleteQuery);
        }
        this.addStatusMessage("Identifying Delta");
        LOG.info("Starting delta collection.");
        HashSet<Map<String, Object>> deletedKeys = new HashSet<Map<String, Object>>();
        Set<Map<String, Object>> allPks = this.collectDelta(this.root, null, resolver, this.dataImporter, deletedKeys);
        if (this.stop.get()) {
            return;
        }
        this.addStatusMessage("Deltas Obtained");
        this.addStatusMessage("Building documents");
        if (!deletedKeys.isEmpty()) {
            this.deleteAll(deletedKeys);
            this.importStatistics.deletedDocCount.addAndGet(deletedKeys.size());
            allPks.removeAll(deletedKeys);
        }
        this.statusMessages.put("Total Changed Documents", allPks.size());
        for (Map<String, Object> pk : allPks) {
            VariableResolverImpl vri = this.getVariableResolver(this.dataImporter);
            vri.addNamespace("dataimporter.delta", pk);
            this.buildDocument(vri, null, pk, this.root, true, null);
        }
        if (!this.stop.get()) {
            this.writer.persistIndexStartTime(this.dataImporter.getIndexStartTime());
            LOG.info("Delta Import completed successfully");
        }
    }

    private void deleteAll(Set<Map<String, Object>> deletedKeys) {
        LOG.info("Deleting stale documents ");
        for (Map<String, Object> deletedKey : deletedKeys) {
            this.writer.deleteDoc(deletedKey.get(this.root.pk));
        }
    }

    public void addStatusMessage(String msg) {
        this.statusMessages.put(msg, DataImporter.DATE_TIME_FORMAT.format(new Date()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void buildDocument(VariableResolverImpl vr, SolrWriter.SolrDoc doc, Map<String, Object> pk, DataConfig.Entity entity, boolean isRoot, ContextImpl parentCtx) {
        block37: {
            entityProcessor = DocBuilder.getEntityProcessor(entity, this.dataImporter.getCore());
            ds = entity.dataSrc;
            if (this.verboseDebug) {
                ds = DebugLogger.wrapDs(ds);
            }
            ctx = new ContextImpl(entity, vr, ds, pk == null ? 1 : 2, this.requestParameters.requestParams, this.session, parentCtx, this.dataImporter);
            entityProcessor.init(ctx);
            if (this.requestParameters.start > 0) {
                this.writer.log(12, null, null);
            }
            if (this.verboseDebug) {
                this.writer.log(1, entity.name, null);
            }
            seenDocCount = 0;
            while (true) lbl-1000:
            // 7 sources

            {
                if (this.stop.get()) {
                    return;
                }
                try {
                    if (++seenDocCount > this.requestParameters.start) {
                        this.writer.log(13, null, null);
                    }
                    if (this.verboseDebug && entity.isDocRoot) {
                        this.writer.log(6, entity.name, null);
                    }
                    if (doc == null && entity.isDocRoot) {
                        if (ctx.getDocSession() != null) {
                            ctx.getDocSession().clear();
                        } else {
                            ctx.setDocSession(new HashMap<String, Object>());
                        }
                        doc = this.writer.getSolrDocInstance();
                        e = entity;
                        while (e.parentEntity != null) {
                            this.addFields(e.parentEntity, doc, (Map)vr.resolve(e.parentEntity.name));
                            e = e.parentEntity;
                        }
                    }
                    if ((arow = entityProcessor.nextRow()) != null) {
                        if (arow.containsKey("$docBoost")) {
                            this.setDocumentBoost(doc, arow);
                        }
                        if (entity.isDocRoot && seenDocCount <= this.requestParameters.start) ** GOTO lbl-1000
                        if (this.verboseDebug) {
                            this.writer.log(8, entity.name, arow);
                        }
                        this.importStatistics.rowsCount.incrementAndGet();
                        if (entity.fields != null && doc != null) {
                            this.addFields(entity, doc, arow);
                        }
                        if (isRoot) {
                            vr.removeNamespace(null);
                        }
                        if (entity.entities != null) {
                            vr.addNamespace(entity.name, arow);
                            for (DataConfig.Entity child : entity.entities) {
                                this.buildDocument(vr, doc, null, child, false, ctx);
                            }
                            vr.removeNamespace(entity.name);
                        }
                        if (!entity.isDocRoot) ** GOTO lbl-1000
                        if (this.stop.get()) {
                            return;
                        }
                        result = this.writer.upload(doc);
                        doc = null;
                        if (!result) ** GOTO lbl-1000
                        this.importStatistics.docCount.incrementAndGet();
                    }
                    break block37;
                }
                catch (DataImportHandlerException e) {
                    if (this.verboseDebug) {
                        this.writer.log(11, entity.name, e);
                    }
                    if (isRoot) {
                        if (e.getErrCode() == 300) {
                            this.importStatistics.skipDocCount.getAndIncrement();
                        } else {
                            DocBuilder.LOG.log(Level.SEVERE, "Exception while processing: " + entity.name + " document : " + doc, e);
                        }
                        if (e.getErrCode() != 500) ** GOTO lbl-1000
                        throw e;
                    }
                    throw e;
                }
                finally {
                    if (!this.verboseDebug) continue;
                    this.writer.log(9, entity.name, null);
                    if (!entity.isDocRoot) continue;
                    this.writer.log(7, null, null);
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                if (this.verboseDebug) {
                    this.writer.log(2, null, null);
                }
            }
        }
    }

    private void setDocumentBoost(SolrWriter.SolrDoc doc, Map<String, Object> arow) {
        Object v = arow.get(DOC_BOOST);
        float value = 1.0f;
        value = v instanceof Number ? ((Number)v).floatValue() : Float.parseFloat(v.toString());
        doc.setDocumentBoost(value);
    }

    private void addFields(DataConfig.Entity entity, SolrWriter.SolrDoc doc, Map<String, Object> arow) {
        DataConfig.Entity parentMost = entity;
        while (parentMost.parentEntity != null) {
            parentMost = parentMost.parentEntity;
        }
        for (DataConfig.Field field : entity.fields) {
            this.addFieldValue(field, arow, null, doc);
        }
        if (parentMost.implicitFields != null) {
            HashMap<String, Object> lowerCaseMap = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : arow.entrySet()) {
                lowerCaseMap.put(entry.getKey().toLowerCase(), entry.getValue());
            }
            for (DataConfig.Field automaticField : parentMost.implicitFields) {
                this.addFieldValue(automaticField, arow, lowerCaseMap, doc);
            }
        }
    }

    private void addFieldValue(DataConfig.Field field, Map<String, Object> arow, Map<String, Object> lowerCaseMap, SolrWriter.SolrDoc doc) {
        if (!field.toWrite) {
            return;
        }
        Object value = arow.get(field.column);
        if (value == null) {
            if (lowerCaseMap != null) {
                value = lowerCaseMap.get(field.column.toLowerCase());
            }
            if (value == null) {
                return;
            }
        }
        if (value instanceof Collection) {
            Iterator i$;
            Collection collection = (Collection)value;
            if (field.multiValued) {
                for (Object o : collection) {
                    doc.addField(field.nameOrColName, o, field.boost.floatValue());
                }
            } else if (doc.getField(field.nameOrColName) == null && (i$ = collection.iterator()).hasNext()) {
                Object o = i$.next();
                doc.addField(field.nameOrColName, o, field.boost.floatValue());
            }
        } else if (field.multiValued) {
            doc.addField(field.nameOrColName, value, field.boost.floatValue());
        } else if (doc.getField(field.nameOrColName) == null) {
            doc.addField(field.nameOrColName, value, field.boost.floatValue());
        }
    }

    public static EntityProcessor getEntityProcessor(DataConfig.Entity entity, SolrCore core) {
        EntityProcessor entityProcessor;
        if (entity.processor != null) {
            return entity.processor;
        }
        if (entity.proc == null) {
            entityProcessor = new SqlEntityProcessor();
        } else {
            try {
                entityProcessor = (EntityProcessor)DocBuilder.loadClass(entity.proc, core).newInstance();
            }
            catch (Exception e) {
                throw new DataImportHandlerException(500, "Unable to load EntityProcessor implementation for entity:" + entity.name, e);
            }
        }
        entity.processor = entityProcessor;
        return entity.processor;
    }

    public Set<Map<String, Object>> collectDelta(DataConfig.Entity entity, DataConfig.Entity parentEntity, VariableResolverImpl resolver, DataImporter context, Set<Map<String, Object>> deletedRows) {
        Map<String, Object> row;
        Map<String, Object> row2;
        if (this.stop.get()) {
            return new HashSet<Map<String, Object>>();
        }
        HashSet<Map<String, Object>> myModifiedPks = new HashSet<Map<String, Object>>();
        if (entity.entities != null) {
            for (DataConfig.Entity entity1 : entity.entities) {
                myModifiedPks.addAll(this.collectDelta(entity1, entity, resolver, context, deletedRows));
            }
        }
        HashSet<Map<String, Object>> deltaSet = new HashSet<Map<String, Object>>();
        resolver.addNamespace(null, entity.allAttributes);
        EntityProcessor entityProcessor = DocBuilder.getEntityProcessor(entity, context.getCore());
        entityProcessor.init(new ContextImpl(entity, resolver, entity.dataSrc, 3, this.requestParameters.requestParams, this.session, null, this.dataImporter));
        LOG.info("Running ModifiedRowKey() for Entity: " + entity.name);
        int count = 0;
        while ((row2 = entityProcessor.nextModifiedRowKey()) != null) {
            deltaSet.add(row2);
            ++count;
            this.importStatistics.rowsCount.incrementAndGet();
        }
        LOG.info("Completed ModifiedRowKey for Entity: " + entity.name + " rows obtained : " + count);
        count = 0;
        LOG.info("Running DeletedRowKey() for Entity: " + entity.name);
        HashSet<Map<String, Object>> deletedSet = new HashSet<Map<String, Object>>();
        while ((row = entityProcessor.nextDeletedRowKey()) != null) {
            deletedSet.add(row);
            ++count;
            this.importStatistics.rowsCount.incrementAndGet();
        }
        LOG.info("Completed DeletedRowKey for Entity: " + entity.name + " rows obtained : " + count);
        myModifiedPks.addAll(deltaSet);
        HashSet<Map<String, Object>> parentKeyList = new HashSet<Map<String, Object>>();
        if (parentEntity != null && parentEntity.isDocRoot) {
            EntityProcessor parentEntityProcessor = DocBuilder.getEntityProcessor(parentEntity, context.getCore());
            parentEntityProcessor.init(new ContextImpl(parentEntity, resolver, parentEntity.dataSrc, 3, this.requestParameters.requestParams, this.session, null, this.dataImporter));
            for (Map map : myModifiedPks) {
                this.getModifiedParentRows(resolver.addNamespace(entity.name, map), entity.name, parentEntityProcessor, parentKeyList);
            }
            for (Map map : deletedSet) {
                this.getModifiedParentRows(resolver.addNamespace(entity.name, map), entity.name, parentEntityProcessor, parentKeyList);
            }
        }
        LOG.info("Completed parentDeltaQuery for Entity: " + entity.name);
        if (entity.isDocRoot) {
            deletedRows.addAll(deletedSet);
        }
        return entity.isDocRoot ? myModifiedPks : new HashSet<Map<String, Object>>(parentKeyList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getModifiedParentRows(VariableResolverImpl resolver, String entity, EntityProcessor entityProcessor, Set<Map<String, Object>> parentKeyList) {
        try {
            Map<String, Object> parentRow;
            while ((parentRow = entityProcessor.nextModifiedParentRowKey()) != null) {
                parentKeyList.add(parentRow);
                this.importStatistics.rowsCount.incrementAndGet();
            }
        }
        finally {
            resolver.removeNamespace(entity);
        }
    }

    public void abort() {
        this.stop.set(true);
    }

    public static void main(String[] args) throws InterruptedException {
        long l = System.currentTimeMillis();
        Thread.sleep(1050L);
        System.out.println(DocBuilder.getTimeElapsedSince(l));
    }

    static String getTimeElapsedSince(long l) {
        l = System.currentTimeMillis() - l;
        return l / 3600000L % 60L + ":" + l / 60000L % 60L + ":" + l / 1000L % 60L + "." + l % 1000L;
    }

    static Class loadClass(String name, SolrCore core) throws ClassNotFoundException {
        try {
            return core != null ? core.getResourceLoader().findClass(name, new String[0]) : Class.forName(name);
        }
        catch (Exception e) {
            try {
                String n = DocBuilder.class.getPackage().getName() + "." + name;
                return core != null ? core.getResourceLoader().findClass(n, new String[0]) : Class.forName(n);
            }
            catch (Exception e1) {
                throw new ClassNotFoundException("Unable to load " + name + " or " + DocBuilder.class.getPackage().getName() + "." + name, e);
            }
        }
    }

    public static class Statistics {
        public AtomicInteger docCount = new AtomicInteger();
        public AtomicInteger deletedDocCount = new AtomicInteger();
        public AtomicLong rowsCount = new AtomicLong();
        public AtomicLong queryCount = new AtomicLong();
        public AtomicLong skipDocCount = new AtomicLong();

        public Statistics add(Statistics stats) {
            this.docCount.addAndGet(stats.docCount.get());
            this.deletedDocCount.addAndGet(stats.deletedDocCount.get());
            this.rowsCount.addAndGet(stats.rowsCount.get());
            this.queryCount.addAndGet(stats.queryCount.get());
            return this;
        }
    }
}

