/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.ContextImpl;
import org.apache.solr.handler.dataimport.DataConfig;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.EntityProcessor;
import org.apache.solr.handler.dataimport.SolrWriter;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.apache.solr.handler.dataimport.VariableResolverImpl;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.util.AbstractSolrTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataImportHandlerTest
extends AbstractSolrTestCase {
    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected String loadDataConfig(String dataConfigFileName) {
        try {
            SolrCore core = this.h.getCore();
            return SolrWriter.getResourceAsString(core.getResourceLoader().openResource(dataConfigFileName));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void runFullImport(String dataConfig) throws Exception {
        LocalSolrQueryRequest request = this.lrf.makeRequest(new String[]{"command", "full-import", "debug", "on", "clean", "true", "commit", "true", "dataConfig", dataConfig});
        this.h.query("/dataimport", (SolrQueryRequest)request);
    }

    protected void runDeltaImport(String dataConfig) throws Exception {
        LocalSolrQueryRequest request = this.lrf.makeRequest(new String[]{"command", "delta-import", "debug", "on", "clean", "true", "commit", "true", "dataConfig", dataConfig});
        this.h.query("/dataimport", (SolrQueryRequest)request);
    }

    public static Context getContext(DataConfig.Entity parentEntity, VariableResolverImpl resolver, DataSource parentDataSource, int currProcess, final List<Map<String, String>> entityFields, final Map<String, String> entityAttrs) {
        final ContextImpl delegate = new ContextImpl(parentEntity, resolver, parentDataSource, currProcess, Collections.EMPTY_MAP, new HashMap<String, Object>(), null, null);
        return new Context(){

            @Override
            public String getEntityAttribute(String name) {
                return entityAttrs == null ? delegate.getEntityAttribute(name) : (String)entityAttrs.get(name);
            }

            @Override
            public List<Map<String, String>> getAllEntityFields() {
                return entityFields == null ? delegate.getAllEntityFields() : entityFields;
            }

            @Override
            public VariableResolver getVariableResolver() {
                return delegate.getVariableResolver();
            }

            @Override
            public DataSource getDataSource() {
                return delegate.getDataSource();
            }

            @Override
            public boolean isRootEntity() {
                return false;
            }

            @Override
            public int currentProcess() {
                return delegate.currentProcess();
            }

            @Override
            public Map<String, Object> getRequestParameters() {
                return delegate.getRequestParameters();
            }

            @Override
            public EntityProcessor getEntityProcessor() {
                return null;
            }

            @Override
            public void setSessionAttribute(String name, Object val, String scope) {
                delegate.setSessionAttribute(name, val, scope);
            }

            @Override
            public Object getSessionAttribute(String name, String scope) {
                return delegate.getSessionAttribute(name, scope);
            }

            @Override
            public Context getParentContext() {
                return delegate.getParentContext();
            }

            @Override
            public DataSource getDataSource(String name) {
                return delegate.getDataSource(name);
            }

            @Override
            public SolrCore getSolrCore() {
                return delegate.getSolrCore();
            }
        };
    }

    public static Map createMap(Object ... args) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        if (args == null || args.length == 0) {
            return result;
        }
        for (int i = 0; i < args.length - 1; i += 2) {
            result.put(args[i], args[i + 1]);
        }
        return result;
    }
}

