/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ru;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ru.RussianStemmer;

public final class RussianStemFilter
extends TokenFilter {
    private RussianStemmer stemmer = null;

    public RussianStemFilter(TokenStream in, char[] charset) {
        super(in);
        this.stemmer = new RussianStemmer(charset);
    }

    public final Token next(Token reusableToken) throws IOException {
        assert (reusableToken != null);
        Token nextToken = this.input.next(reusableToken);
        if (nextToken == null) {
            return null;
        }
        String term = nextToken.term();
        String s = this.stemmer.stem(term);
        if (s != null && !s.equals(term)) {
            nextToken.setTermBuffer(s);
        }
        return nextToken;
    }

    public void setStemmer(RussianStemmer stemmer) {
        if (stemmer != null) {
            this.stemmer = stemmer;
        }
    }
}

