/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.payloads;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.payloads.PayloadHelper;
import org.apache.lucene.index.Payload;

public class TokenOffsetPayloadTokenFilter
extends TokenFilter {
    public TokenOffsetPayloadTokenFilter(TokenStream input) {
        super(input);
    }

    public Token next(Token reusableToken) throws IOException {
        assert (reusableToken != null);
        Token nextToken = this.input.next(reusableToken);
        if (nextToken != null) {
            byte[] data = new byte[8];
            PayloadHelper.encodeInt(nextToken.startOffset(), data, 0);
            PayloadHelper.encodeInt(nextToken.endOffset(), data, 4);
            Payload payload = new Payload(data);
            nextToken.setPayload(payload);
        }
        return nextToken;
    }
}

