/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptorDictionary;

public abstract class PDCIDFont
extends PDFont {
    private Map widthCache = new HashMap();

    public PDCIDFont() {
    }

    public PDCIDFont(COSDictionary fontDictionary) {
        super(fontDictionary);
    }

    public PDFontDescriptor getFontDescriptor() {
        PDFontDescriptorDictionary desc = null;
        COSDictionary dict = (COSDictionary)this.font.getDictionaryObject("FontDescriptor");
        if (dict != null) {
            desc = new PDFontDescriptorDictionary(dict);
        }
        return desc;
    }

    public void setFontDescriptor(PDFontDescriptorDictionary desc) {
        this.font.setItem("FontDescriptor", (COSObjectable)desc);
    }

    public void drawString(String string, Graphics g, float fontSize, AffineTransform at, float x, float y) {
        throw new RuntimeException("Not yet implemented");
    }

    public PDRectangle getFontBoundingBox() throws IOException {
        throw new RuntimeException("Not yet implemented");
    }

    public long getDefaultWidth() {
        long dw = 1000L;
        COSNumber number = (COSNumber)this.font.getDictionaryObject(COSName.DW);
        if (number != null) {
            dw = number.intValue();
        }
        return dw;
    }

    public void setDefaultWidth(long dw) {
        this.font.setItem(COSName.DW, (COSBase)new COSInteger(dw));
    }

    public float getFontWidth(byte[] c, int offset, int length) throws IOException {
        float retval = 0.0f;
        int code = this.getCodeFromArray(c, offset, length);
        Float widthFloat = (Float)this.widthCache.get(new Integer(code));
        if (widthFloat == null) {
            COSArray widths = (COSArray)this.font.getDictionaryObject(COSName.W);
            if (widths != null) {
                boolean foundWidth = false;
                for (int i = 0; !foundWidth && i < widths.size(); ++i) {
                    COSNumber rangeWidth;
                    COSNumber firstCode = (COSNumber)widths.getObject(i++);
                    COSBase next = widths.getObject(i);
                    if (next instanceof COSArray) {
                        COSArray array = (COSArray)next;
                        if (code < firstCode.intValue() || code >= firstCode.intValue() + array.size()) continue;
                        rangeWidth = (COSNumber)array.get(code - firstCode.intValue());
                        retval = rangeWidth.floatValue();
                        foundWidth = true;
                        continue;
                    }
                    COSNumber secondCode = (COSNumber)next;
                    rangeWidth = (COSNumber)widths.getObject(++i);
                    if (code < firstCode.intValue() || code > secondCode.intValue()) continue;
                    retval = rangeWidth.floatValue();
                    foundWidth = true;
                }
                this.widthCache.put(new Integer(code), new Float(retval));
            }
        } else {
            retval = widthFloat.floatValue();
        }
        return retval;
    }

    public float getFontHeight(byte[] c, int offset, int length) throws IOException {
        float retval = 0.0f;
        PDFontDescriptor desc = this.getFontDescriptor();
        float xHeight = desc.getXHeight();
        float capHeight = desc.getCapHeight();
        retval = xHeight != 0.0f && capHeight != 0.0f ? (xHeight + capHeight) / 2.0f : (xHeight != 0.0f ? xHeight : (capHeight != 0.0f ? capHeight : 0.0f));
        if (retval == 0.0f) {
            retval = desc.getAscent();
        }
        return retval;
    }

    public float getAverageFontWidth() throws IOException {
        float average;
        float totalWidths = 0.0f;
        float characterCount = 0.0f;
        float defaultWidth = this.getDefaultWidth();
        COSArray widths = (COSArray)this.font.getDictionaryObject(COSName.W);
        if (widths != null) {
            for (int i = 0; i < widths.size(); ++i) {
                COSNumber rangeWidth;
                COSNumber firstCode = (COSNumber)widths.getObject(i++);
                COSBase next = widths.getObject(i);
                if (next instanceof COSArray) {
                    COSArray array = (COSArray)next;
                    for (int j = 0; j < array.size(); ++j) {
                        COSNumber width = (COSNumber)array.get(j);
                        totalWidths += width.floatValue();
                        characterCount += 1.0f;
                    }
                    continue;
                }
                if (!((rangeWidth = (COSNumber)widths.getObject(++i)).floatValue() > 0.0f)) continue;
                totalWidths += rangeWidth.floatValue();
                characterCount += 1.0f;
            }
        }
        if ((average = totalWidths / characterCount) <= 0.0f) {
            average = defaultWidth;
        }
        return average;
    }
}

