/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.unit;

import java.util.Iterator;
import java.util.Map;
import org.seasar.extension.dataset.ColumnType;
import org.seasar.extension.dataset.DataColumn;
import org.seasar.extension.dataset.DataReader;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.impl.DataSetImpl;
import org.seasar.extension.dataset.states.RowStates;
import org.seasar.extension.dataset.types.ColumnTypes;

public class MapReader
implements DataReader {
    private DataSet dataSet = new DataSetImpl();
    private DataTable table = this.dataSet.addTable("Map");

    protected MapReader() {
    }

    public MapReader(Map map) {
        this.setupColumns(map);
        this.setupRow(map);
    }

    protected void setupColumns(Map map) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            this.table.addColumn(key);
        }
    }

    protected void setupRow(Map map) {
        DataRow row = this.table.addRow();
        for (int i = 0; i < this.table.getColumnSize(); ++i) {
            DataColumn column = this.table.getColumn(i);
            Object value = map.get(column.getColumnName());
            if (value == null) continue;
            ColumnType ct = ColumnTypes.getColumnType(value.getClass());
            row.setValue(column.getColumnName(), ct.convert(value, null));
        }
        row.setState(RowStates.UNCHANGED);
    }

    public DataSet read() {
        return this.dataSet;
    }
}

