/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import org.mobylet.core.MobyletFactory;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.http.MobyletResponse;
import org.mobylet.core.util.RequestUtils;

public class ForceWrapServletOutputStream
extends ServletOutputStream {
    public static final String KEY_PROXY_CHARSET = "X_MOBYLET_PROXY_CHARSET";
    protected PrintWriter writer;
    protected ByteArrayOutputStream baos;
    protected String proxyCharset = "UTF-8";

    public ForceWrapServletOutputStream(MobyletResponse response) {
        try {
            this.writer = response.getWriter();
        }
        catch (IOException e) {
            throw new MobyletRuntimeException("\u5f37\u5236PrintWriter\u53d6\u5f97\u51e6\u7406\u3067\u4f8b\u5916\u767a\u751f", e);
        }
        Object tmpProxyCharset = null;
        if (RequestUtils.get() != null && (tmpProxyCharset = RequestUtils.get().getAttribute(KEY_PROXY_CHARSET)) != null && tmpProxyCharset != null) {
            this.proxyCharset = tmpProxyCharset.toString();
        }
        this.baos = new ByteArrayOutputStream(8192);
    }

    public void write(int b) throws IOException {
        this.baos.write(b);
    }

    public void flush() throws IOException {
        if (this.baos.size() > 0) {
            this.writer.write(this.baos.toString(this.proxyCharset).toCharArray());
        }
        super.flush();
    }

    public int getLength() {
        if (this.baos.size() > 0) {
            try {
                return this.baos.toString(this.proxyCharset).getBytes(MobyletFactory.getInstance().getDialect().getCharset()).length;
            }
            catch (UnsupportedEncodingException e) {
                return 0;
            }
        }
        return 0;
    }
}

