/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.http;

import java.io.PrintWriter;
import java.io.StringReader;
import org.mobylet.core.util.RequestUtils;
import org.mobylet.core.util.StringUtils;
import org.mobylet.core.util.XmlUtils;
import org.mobylet.view.css.CSSCondContainer;
import org.mobylet.view.css.CSSExpandHandler;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class CSSExpandPrintWriter
extends PrintWriter {
    protected StringBuilder buf;
    protected PrintWriter writer;

    public CSSExpandPrintWriter(PrintWriter out) {
        super(out);
        this.writer = out;
        this.buf = new StringBuilder(1024);
    }

    @Override
    public void write(int c) {
        this.buf.append(c);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        this.buf.append(buf, off, len);
    }

    @Override
    public void write(String s, int off, int len) {
        if (StringUtils.isNotEmpty(s)) {
            this.buf.append(s.toCharArray(), off, len);
        }
    }

    public void flushByMobylet() {
        int index = this.buf.indexOf("<html");
        if (index < 0) {
            index = 0;
        }
        InputSource inputSource = new InputSource(new StringReader(this.buf.substring(index)));
        CSSCondContainer container = null;
        if (RequestUtils.get() != null && RequestUtils.getMobyletContext() != null) {
            container = RequestUtils.getMobyletContext().get(CSSCondContainer.class);
        }
        CSSExpandHandler handler = new CSSExpandHandler(container);
        XmlUtils.parseSax(inputSource, (DefaultHandler)handler);
        if (index > 0) {
            this.writer.write(this.buf.substring(0, index));
        }
        this.writer.write(handler.toString());
        this.writer.flush();
    }
}

