/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.gps.impl;

import org.mobylet.core.gps.Geo;
import org.mobylet.core.gps.GeoConverter;
import org.mobylet.core.gps.Gps;

public class MobyletGeoConverter
implements GeoConverter {
    @Override
    public Gps toTokyo(Gps in) {
        if (in.getGeo() == Geo.WGS84) {
            Rectangular r = this.ellip2Rect(in, 6378137.0, 0.006694380002756625);
            r = new Rectangular(r.getX() + 148.0, r.getY() + -507.0, r.getZ() + -681.0);
            Gps g = this.rect2Ellip(r, 6377397.155, 0.006674372227347433);
            g.setGeo(Geo.TOKYO);
            return g;
        }
        return in;
    }

    @Override
    public Gps toWgs84(Gps in) {
        if (in.getGeo() == Geo.TOKYO) {
            Rectangular r = this.ellip2Rect(in, 6377397.155, 0.006674372227347433);
            r = new Rectangular(r.getX() + -148.0, r.getY() + 507.0, r.getZ() + 681.0);
            Gps g = this.rect2Ellip(r, 6378137.0, 0.006694380002756625);
            g.setGeo(Geo.WGS84);
            return g;
        }
        return in;
    }

    protected Rectangular ellip2Rect(Gps g, double sa, double ecc) {
        double rLat = g.getLat() * (Math.PI / 180);
        double sinLat = Math.sin(rLat);
        double cosLat = Math.cos(rLat);
        double rLon = g.getLon() * (Math.PI / 180);
        double sinLon = Math.sin(rLon);
        double cosLon = Math.cos(rLon);
        double rn = sa / Math.sqrt(1.0 - ecc * sinLat * sinLat);
        double x = (rn + g.getHeight()) * cosLat * cosLon;
        double y = (rn + g.getHeight()) * cosLat * sinLon;
        double z = (rn * (1.0 - ecc) + g.getHeight()) * sinLat;
        return new Rectangular(x, y, z);
    }

    protected Gps rect2Ellip(Rectangular r, double sa, double ecc) {
        double bpa = Math.sqrt(1.0 - ecc);
        double p = Math.sqrt(r.getX() * r.getX() + r.getY() * r.getY());
        double t = Math.atan2(r.getZ(), p * bpa);
        double sinT = Math.sin(t);
        double cosT = Math.cos(t);
        double rLat = Math.atan2(r.getZ() + ecc * sa / bpa * Math.pow(sinT, 3.0), p - ecc * sa * Math.pow(cosT, 3.0));
        double rLon = Math.atan2(r.getY(), r.getX());
        double sinLat = Math.sin(rLat);
        double rn = sa / Math.sqrt(1.0 - ecc * sinLat * sinLat);
        double h = p / Math.cos(rLat) - rn;
        Gps g = new Gps(rLat / (Math.PI / 180), rLon / (Math.PI / 180), null);
        g.setHeight(h);
        return g;
    }

    public class Rectangular {
        public double x;
        public double y;
        public double z;

        public Rectangular(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getZ() {
            return this.z;
        }
    }
}

