/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.emoji.impl;

import java.util.Stack;
import org.mobylet.core.Carrier;
import org.mobylet.core.emoji.Emoji;
import org.mobylet.core.emoji.EmojiPool;
import org.mobylet.core.emoji.EmojiPoolFamily;
import org.mobylet.core.emoji.EmojiPoolReader;
import org.mobylet.core.emoji.impl.MobyletEmojiPoolXml;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;
import org.mobylet.core.util.XmlUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MobyletEmojiPoolReader
extends DefaultHandler
implements EmojiPoolReader,
MobyletEmojiPoolXml {
    protected EmojiPool pool;
    protected Stack<String> tagStack;
    protected Emoji targetEmoji;
    protected Carrier relationCarrier;
    protected String relationValue;

    @Override
    public EmojiPool get() {
        return this.pool;
    }

    @Override
    public EmojiPoolReader read(String path) {
        XmlUtils.parseSax(path, (DefaultHandler)this);
        return this;
    }

    @Override
    public void startDocument() throws SAXException {
        this.tagStack = new Stack();
        super.startDocument();
    }

    @Override
    public void startElement(String url, String localName, String name, Attributes attributes) throws SAXException {
        this.tagStack.push(name);
        if ("emojipool".equals(name)) {
            Carrier carrier = Carrier.OTHER;
            String carrierStr = attributes.getValue("carrier");
            if (StringUtils.isNotEmpty(carrierStr)) {
                carrier = Carrier.valueOf(carrierStr);
            }
            this.pool = SingletonUtils.get(EmojiPoolFamily.class).getEmojiPool(carrier);
        } else if ("emoji".equals(name)) {
            String codeStr = attributes.getValue("code");
            String emojiName = attributes.getValue("name");
            if (StringUtils.isNotEmpty(codeStr) && codeStr.startsWith("0x")) {
                char c = (char)Integer.parseInt(codeStr.substring(2), 16);
                this.targetEmoji = this.pool.putWithName(emojiName, c);
            }
        } else if ("relation".equals(name)) {
            Carrier carrier = Carrier.OTHER;
            String carrierStr = attributes.getValue("carrier");
            if (StringUtils.isNotEmpty(carrierStr)) {
                carrier = Carrier.valueOf(carrierStr);
            }
            this.relationCarrier = carrier;
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        this.tagStack.pop();
        if ("relation".equals(name)) {
            if (StringUtils.isNotEmpty(this.relationValue)) {
                EmojiPool relationPool = SingletonUtils.get(EmojiPoolFamily.class).getEmojiPool(this.relationCarrier);
                Emoji e = null;
                if (this.relationValue.startsWith("0x")) {
                    char c = (char)Integer.parseInt(this.relationValue.substring(2), 16);
                    e = relationPool.getUnConstructed(c);
                    if (e == null) {
                        e = relationPool.putWithName(null, c);
                    }
                } else {
                    e = new Emoji(this.relationCarrier, this.relationValue);
                }
                this.targetEmoji.relate(this.relationCarrier, e);
                this.relationCarrier = null;
                this.relationValue = null;
            }
        } else if ("emoji".equals(name)) {
            this.targetEmoji = null;
        }
    }

    @Override
    public void characters(char[] ac, int i, int j) throws SAXException {
        if ("relation".equals(this.tagStack.peek())) {
            this.relationValue = StringUtils.isEmpty(this.relationValue) ? new String(ac, i, j) : this.relationValue + new String(ac, i, j);
        }
    }
}

