/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.device.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mobylet.core.MobyletFactory;
import org.mobylet.core.device.Device;
import org.mobylet.core.device.DevicePool;
import org.mobylet.core.device.DeviceReader;
import org.mobylet.core.util.RequestUtils;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;

public class MobyletDevicePool
implements DevicePool {
    protected Map<String, Device> deviceMap = new HashMap<String, Device>(1024);

    public MobyletDevicePool() {
        DeviceReader reader = SingletonUtils.get(DeviceReader.class);
        this.deviceMap.putAll(reader.read());
    }

    @Override
    public Device get() {
        return this.deviceMap.get(this.getKeyString());
    }

    public String getKeyString() {
        Matcher matcher;
        Pattern regex = MobyletFactory.getInstance().getDialect().getDeviceMatchRegex();
        String userAgent = RequestUtils.getUserAgent();
        if (StringUtils.isNotEmpty(userAgent) && (matcher = regex.matcher(userAgent)).find()) {
            return matcher.group();
        }
        return null;
    }
}

