/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.s2dao.sqlhandler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.seasar.robot.dbflute.jdbc.StatementFactory;
import org.seasar.robot.dbflute.jdbc.ValueType;
import org.seasar.robot.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.robot.dbflute.s2dao.sqlhandler.TnBasicHandler;
import org.seasar.robot.dbflute.twowaysql.context.CommandContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnCommandContextHandler
extends TnBasicHandler {
    protected CommandContext commandContext;
    protected List<TnPropertyType> propertyTypeList;

    public TnCommandContextHandler(DataSource dataSource, StatementFactory statementFactory, CommandContext commandContext) {
        super(dataSource, statementFactory);
        this.commandContext = commandContext;
        this.setSql(commandContext.getSql());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Object[] args) {
        Connection connection = this.getConnection();
        try {
            int n = this.execute(connection, this.commandContext);
            return n;
        }
        finally {
            this.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int execute(Connection connection, CommandContext context) {
        this.logSql(context.getBindVariables(), this.getArgTypes(context.getBindVariables()));
        PreparedStatement ps = this.prepareStatement(connection);
        int ret = -1;
        try {
            Object[] bindVariables = context.getBindVariables();
            Class<?>[] bindVariableTypes = context.getBindVariableTypes();
            if (this.hasPropertyTypeList()) {
                int index = this.bindFirstScope(ps, bindVariables, bindVariableTypes);
                this.bindSecondScope(ps, bindVariables, bindVariableTypes, index);
            } else {
                this.bindArgs(ps, bindVariables, bindVariableTypes);
            }
            ret = this.executeUpdate(ps);
        }
        finally {
            this.close(ps);
        }
        return ret;
    }

    protected boolean hasPropertyTypeList() {
        return this.propertyTypeList != null && !this.propertyTypeList.isEmpty();
    }

    protected int bindFirstScope(PreparedStatement ps, Object[] bindVariables, Class<?>[] bindVariableTypes) {
        ArrayList<Object> firstVariableList = new ArrayList<Object>();
        ArrayList<ValueType> firstValueTypeList = new ArrayList<ValueType>();
        int index = 0;
        for (TnPropertyType propertyType : this.propertyTypeList) {
            firstVariableList.add(bindVariables[index]);
            firstValueTypeList.add(propertyType.getValueType());
            ++index;
        }
        this.bindArgs(ps, firstVariableList.toArray(), firstValueTypeList.toArray(new ValueType[0]));
        return index;
    }

    protected void bindSecondScope(PreparedStatement ps, Object[] bindVariables, Class<?>[] bindVariableTypes, int index) {
        this.bindArgs(ps, bindVariables, bindVariableTypes, index);
    }

    public List<TnPropertyType> getPropertyTypeList() {
        return this.propertyTypeList;
    }

    public void setPropertyTypeList(List<TnPropertyType> propertyTypeList) {
        this.propertyTypeList = propertyTypeList;
    }
}

