/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.s2dao.metadata.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;
import javax.sql.DataSource;
import org.seasar.robot.dbflute.helper.beans.DfBeanDesc;
import org.seasar.robot.dbflute.helper.beans.DfPropertyDesc;
import org.seasar.robot.dbflute.helper.beans.factory.DfBeanDescFactory;
import org.seasar.robot.dbflute.resource.SQLExceptionHandler;
import org.seasar.robot.dbflute.s2dao.metadata.TnBeanAnnotationReader;
import org.seasar.robot.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.robot.dbflute.s2dao.metadata.TnBeanMetaDataFactory;
import org.seasar.robot.dbflute.s2dao.metadata.TnModifiedPropertySupport;
import org.seasar.robot.dbflute.s2dao.metadata.TnPropertyTypeFactory;
import org.seasar.robot.dbflute.s2dao.metadata.TnPropertyTypeFactoryBuilder;
import org.seasar.robot.dbflute.s2dao.metadata.TnRelationPropertyTypeFactory;
import org.seasar.robot.dbflute.s2dao.metadata.TnRelationPropertyTypeFactoryBuilder;
import org.seasar.robot.dbflute.s2dao.metadata.impl.TnBeanMetaDataImpl;
import org.seasar.robot.dbflute.s2dao.metadata.impl.TnDBMetaBeanAnnotationReader;
import org.seasar.robot.dbflute.s2dao.metadata.impl.TnPropertyTypeFactoryBuilderImpl;
import org.seasar.robot.dbflute.s2dao.metadata.impl.TnRelationPropertyTypeFactoryBuilderImpl;
import org.seasar.robot.dbflute.s2dao.valuetype.TnValueTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnBeanMetaDataFactoryImpl
implements TnBeanMetaDataFactory {
    protected DataSource _dataSource;
    protected TnValueTypeFactory _valueTypeFactory;

    @Override
    public TnBeanMetaData createBeanMetaData(Class<?> daoInterface, Class<?> beanClass) {
        return this.createBeanMetaData(beanClass);
    }

    @Override
    public TnBeanMetaData createBeanMetaData(Class<?> beanClass) {
        return this.createBeanMetaData(beanClass, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TnBeanMetaData createBeanMetaData(Class<?> beanClass, int relationNestLevel) {
        if (beanClass == null) {
            throw new NullPointerException("beanClass");
        }
        Connection conn = null;
        try {
            conn = this._dataSource.getConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            TnBeanMetaData tnBeanMetaData = this.createBeanMetaData(metaData, beanClass, relationNestLevel);
            return tnBeanMetaData;
        }
        catch (SQLException e) {
            this.handleSQLException(e);
            TnBeanMetaData tnBeanMetaData = null;
            return tnBeanMetaData;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    this.handleSQLException(e);
                }
            }
        }
    }

    protected void handleSQLException(SQLException e) {
        new SQLExceptionHandler().handleSQLException(e);
    }

    @Override
    public TnBeanMetaData createBeanMetaData(DatabaseMetaData dbMetaData, Class<?> beanClass, int relationNestLevel) {
        if (beanClass == null) {
            throw new NullPointerException("beanClass");
        }
        boolean stopRelationCreation = this.isLimitRelationNestLevel(relationNestLevel);
        TnBeanAnnotationReader bar = this.createBeanAnnotationReader(beanClass);
        String versionNoPropertyName = this.getVersionNoPropertyName(bar);
        String timestampPropertyName = this.getTimestampPropertyName(bar);
        TnPropertyTypeFactory ptf = this.createPropertyTypeFactory(beanClass, bar, dbMetaData);
        TnRelationPropertyTypeFactory rptf = this.createRelationPropertyTypeFactory(beanClass, bar, dbMetaData, relationNestLevel, stopRelationCreation);
        TnBeanMetaDataImpl bmd = this.createBeanMetaDataImpl();
        bmd.setBeanAnnotationReader(bar);
        bmd.setVersionNoPropertyName(versionNoPropertyName);
        bmd.setTimestampPropertyName(timestampPropertyName);
        bmd.setBeanClass(beanClass);
        bmd.setPropertyTypeFactory(ptf);
        bmd.setRelationPropertyTypeFactory(rptf);
        bmd.initialize();
        bmd.setModifiedPropertySupport(new TnModifiedPropertySupport(){

            @Override
            public Set<String> getModifiedPropertyNames(Object bean) {
                String propertyName;
                DfBeanDesc beanDesc = DfBeanDescFactory.getBeanDesc(bean.getClass());
                if (!beanDesc.hasPropertyDesc(propertyName = "modifiedPropertyNames")) {
                    return Collections.EMPTY_SET;
                }
                DfPropertyDesc propertyDesc = beanDesc.getPropertyDesc(propertyName);
                Object value = propertyDesc.getValue(bean);
                Set names = (Set)value;
                return names;
            }
        });
        return bmd;
    }

    protected TnBeanAnnotationReader createBeanAnnotationReader(Class<?> beanClass) {
        return new TnDBMetaBeanAnnotationReader(beanClass);
    }

    protected String getVersionNoPropertyName(TnBeanAnnotationReader beanAnnotationReader) {
        String defaultName = "versionNo";
        String name = beanAnnotationReader.getVersionNoPropertyName();
        return name != null ? name : "versionNo";
    }

    protected String getTimestampPropertyName(TnBeanAnnotationReader beanAnnotationReader) {
        String defaultName = "timestamp";
        String name = beanAnnotationReader.getTimestampPropertyName();
        return name != null ? name : "timestamp";
    }

    protected TnPropertyTypeFactory createPropertyTypeFactory(Class<?> originalBeanClass, TnBeanAnnotationReader beanAnnotationReader, DatabaseMetaData databaseMetaData) {
        return this.createPropertyTypeFactoryBuilder().build(originalBeanClass, beanAnnotationReader);
    }

    protected TnPropertyTypeFactoryBuilder createPropertyTypeFactoryBuilder() {
        TnPropertyTypeFactoryBuilderImpl impl = new TnPropertyTypeFactoryBuilderImpl();
        impl.setValueTypeFactory(this._valueTypeFactory);
        return impl;
    }

    protected TnRelationPropertyTypeFactory createRelationPropertyTypeFactory(Class<?> originalBeanClass, TnBeanAnnotationReader beanAnnotationReader, DatabaseMetaData databaseMetaData, int relationNestLevel, boolean isStopRelationCreation) {
        return this.createRelationPropertyTypeFactoryBuilder().build(originalBeanClass, beanAnnotationReader, databaseMetaData, relationNestLevel, isStopRelationCreation);
    }

    protected TnRelationPropertyTypeFactoryBuilder createRelationPropertyTypeFactoryBuilder() {
        TnRelationPropertyTypeFactoryBuilderImpl impl = new TnRelationPropertyTypeFactoryBuilderImpl();
        impl.setBeanMetaDataFactory(this);
        return impl;
    }

    protected TnBeanMetaDataImpl createBeanMetaDataImpl() {
        return new TnBeanMetaDataImpl();
    }

    protected boolean isLimitRelationNestLevel(int relationNestLevel) {
        return relationNestLevel == this.getLimitRelationNestLevel();
    }

    protected int getLimitRelationNestLevel() {
        return 1;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public void setValueTypeFactory(TnValueTypeFactory valueTypeFactory) {
        this._valueTypeFactory = valueTypeFactory;
    }
}

