/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.dbmeta.info;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.seasar.robot.dbflute.dbmeta.DBMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnInfo {
    protected final DBMeta dbmeta;
    protected final String columnDbName;
    protected final String columnAlias;
    protected final String propertyName;
    protected final Class<?> propertyType;
    protected final boolean primary;
    protected final boolean autoIncrement;
    protected final Integer columnSize;
    protected final Integer columnDecimalDigits;
    protected final boolean commonColumn;
    protected final DBMeta.OptimisticLockType optimisticLockType;

    public ColumnInfo(DBMeta dbmeta, String columnDbName, String columnAlias, String propertyName, Class<?> propertyType, boolean primary, boolean autoIncrement, Integer columnSize, Integer columnDecimalDigits, boolean commonColumn, DBMeta.OptimisticLockType optimisticLockType) {
        this.assertObjectNotNull("dbmeta", dbmeta);
        this.assertObjectNotNull("columnDbName", columnDbName);
        this.assertObjectNotNull("propertyName", propertyName);
        this.assertObjectNotNull("propertyType", propertyType);
        this.dbmeta = dbmeta;
        this.columnDbName = columnDbName;
        this.columnAlias = columnAlias;
        this.propertyName = propertyName;
        this.propertyType = propertyType;
        this.primary = primary;
        this.autoIncrement = autoIncrement;
        this.columnSize = columnSize;
        this.columnDecimalDigits = columnDecimalDigits;
        this.commonColumn = commonColumn;
        this.optimisticLockType = optimisticLockType != null ? optimisticLockType : DBMeta.OptimisticLockType.NONE;
    }

    public Method findSetter() {
        return this.findMethod(this.dbmeta.getEntityType(), "set" + this.buildInitCapPropertyName(), new Class[]{this.propertyType});
    }

    public Method findGetter() {
        return this.findMethod(this.dbmeta.getEntityType(), "get" + this.buildInitCapPropertyName(), new Class[0]);
    }

    protected String buildInitCapPropertyName() {
        return this.initCap(this.propertyName);
    }

    protected String initCap(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected Method findMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        try {
            return clazz.getMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException ex) {
            String msg = "class=" + clazz + " method=" + methodName + "-" + Arrays.asList(argTypes);
            throw new RuntimeException(msg, ex);
        }
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    public int hashCode() {
        return this.dbmeta.hashCode() + this.columnDbName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ColumnInfo)) {
            return false;
        }
        ColumnInfo target = (ColumnInfo)obj;
        if (!this.dbmeta.equals(target.getDBMeta())) {
            return false;
        }
        return this.columnDbName.equals(target.getColumnDbName());
    }

    public String toString() {
        return this.dbmeta.getTableDbName() + "." + this.columnDbName;
    }

    public DBMeta getDBMeta() {
        return this.dbmeta;
    }

    public String getColumnDbName() {
        return this.columnDbName;
    }

    public String getColumnAlias() {
        return this.columnAlias;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public Integer getColumnSize() {
        return this.columnSize;
    }

    public Integer getColumnDecimalDigits() {
        return this.columnDecimalDigits;
    }

    public boolean isCommonColumn() {
        return this.commonColumn;
    }

    public boolean isOptimisticLock() {
        return this.isVersionNo() || this.isUpdateDate();
    }

    public boolean isVersionNo() {
        return DBMeta.OptimisticLockType.VERSION_NO == this.optimisticLockType;
    }

    public boolean isUpdateDate() {
        return DBMeta.OptimisticLockType.UPDATE_DATE == this.optimisticLockType;
    }
}

