/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.bhv.core.command;

import org.seasar.robot.dbflute.bhv.core.SqlExecution;
import org.seasar.robot.dbflute.bhv.core.SqlExecutionCreator;
import org.seasar.robot.dbflute.bhv.core.command.AbstractBehaviorCommand;
import org.seasar.robot.dbflute.bhv.core.command.AbstractOutsideSqlCommand;
import org.seasar.robot.dbflute.outsidesql.OutsideSqlContext;
import org.seasar.robot.dbflute.outsidesql.OutsideSqlOption;
import org.seasar.robot.dbflute.s2dao.procedure.TnProcedureMetaData;
import org.seasar.robot.dbflute.s2dao.procedure.TnProcedureMetaDataFactory;
import org.seasar.robot.dbflute.s2dao.sqlcommand.TnProcedureCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutsideSqlCallCommand
extends AbstractOutsideSqlCommand<Void> {
    @Override
    public String getCommandName() {
        return "call";
    }

    @Override
    public Class<?> getCommandReturnType() {
        return Void.TYPE;
    }

    @Override
    public boolean isProcedure() {
        return true;
    }

    @Override
    public boolean isSelect() {
        return false;
    }

    @Override
    public void beforeGettingSqlExecution() {
        this.assertStatus("beforeGettingSqlExecution");
        String path = this._outsideSqlPath;
        Object pmb = this._parameterBean;
        OutsideSqlOption option = this._outsideSqlOption;
        OutsideSqlContext outsideSqlContext = this.createOutsideSqlContext();
        outsideSqlContext.setDynamicBinding(option.isDynamicBinding());
        outsideSqlContext.setOffsetByCursorForcedly(option.isAutoPaging());
        outsideSqlContext.setLimitByCursorForcedly(option.isAutoPaging());
        outsideSqlContext.setOutsideSqlPath(path);
        outsideSqlContext.setParameterBean(pmb);
        outsideSqlContext.setMethodName(this.getCommandName());
        outsideSqlContext.setStatementConfig(option.getStatementConfig());
        outsideSqlContext.setTableDbName(option.getTableDbName());
        outsideSqlContext.setupBehaviorQueryPathIfNeeds();
        OutsideSqlContext.setOutsideSqlContextOnThread(outsideSqlContext);
    }

    @Override
    public void afterExecuting() {
    }

    @Override
    public String buildSqlExecutionKey() {
        this.assertStatus("buildSqlExecutionKey");
        return this.generateSpecifiedOutsideSqlUniqueKey();
    }

    protected String generateSpecifiedOutsideSqlUniqueKey() {
        String methodName = this.getCommandName();
        String path = this._outsideSqlPath;
        Object pmb = this._parameterBean;
        OutsideSqlOption option = this._outsideSqlOption;
        return OutsideSqlContext.generateSpecifiedOutsideSqlUniqueKey(methodName, path, pmb, option, null);
    }

    @Override
    public SqlExecutionCreator createSqlExecutionCreator() {
        this.assertStatus("createSqlExecutionCreator");
        return new SqlExecutionCreator(){

            public SqlExecution createSqlExecution() {
                OutsideSqlContext outsideSqlContext = OutsideSqlContext.getOutsideSqlContextOnThread();
                return OutsideSqlCallCommand.this.createOutsideSqlCallCommand(outsideSqlContext);
            }
        };
    }

    protected SqlExecution createOutsideSqlCallCommand(OutsideSqlContext outsideSqlContext) {
        Object pmb = outsideSqlContext.getParameterBean();
        String procedureName = outsideSqlContext.getOutsideSqlPath();
        TnProcedureMetaDataFactory factory = this.createProcedureMetaDataFactory();
        factory.setValueTypeFactory(this._valueTypeFactory);
        Class<?> pmbType = pmb != null ? pmb.getClass() : null;
        TnProcedureMetaData metaData = factory.createProcedureMetaData(procedureName, pmbType);
        return this.createProcedureCommand(metaData);
    }

    protected TnProcedureMetaDataFactory createProcedureMetaDataFactory() {
        return new TnProcedureMetaDataFactory();
    }

    protected TnProcedureCommand createProcedureCommand(TnProcedureMetaData metaData) {
        AbstractBehaviorCommand.InternalNullResultSetHandler resultSetHandler = new AbstractBehaviorCommand.InternalNullResultSetHandler();
        return new TnProcedureCommand(this._dataSource, resultSetHandler, this._statementFactory, metaData);
    }

    @Override
    public Object[] getSqlExecutionArgument() {
        return new Object[]{this._parameterBean};
    }

    protected void assertStatus(String methodName) {
        this.assertBasicProperty(methodName);
        this.assertComponentProperty(methodName);
        this.assertOutsideSqlBasic(methodName);
        if (this._parameterBean == null) {
            String msg = "The property 'parameterBean' should not be null";
            msg = msg + " when you call " + methodName + "().";
            throw new IllegalStateException(msg);
        }
    }
}

