/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.LevensteinDistance;
import org.apache.lucene.search.spell.SpellChecker;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.FieldType;
import org.apache.solr.spelling.SolrSpellChecker;
import org.apache.solr.spelling.SpellingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLuceneSpellChecker
extends SolrSpellChecker {
    public static final Logger LOG = Logger.getLogger(AbstractLuceneSpellChecker.class.getName());
    public static final String SPELLCHECKER_ARG_NAME = "spellchecker";
    public static final String LOCATION = "sourceLocation";
    public static final String INDEX_DIR = "spellcheckIndexDir";
    public static final String ACCURACY = "accuracy";
    public static final String STRING_DISTANCE = "distanceMeasure";
    public static final String FIELD_TYPE = "fieldType";
    protected String field;
    protected String fieldTypeName;
    protected SpellChecker spellChecker;
    protected String sourceLocation;
    protected Directory index;
    protected Dictionary dictionary;
    public static final int DEFAULT_SUGGESTION_COUNT = 5;
    protected String indexDir;
    protected float accuracy = 0.5f;
    public static final String FIELD = "field";

    @Override
    public String init(NamedList config, SolrCore core) {
        super.init(config, core);
        this.indexDir = (String)config.get(INDEX_DIR);
        String accuracy = (String)config.get(ACCURACY);
        if (this.indexDir != null && !new File(this.indexDir).isAbsolute()) {
            this.indexDir = core.getDataDir() + File.separator + this.indexDir;
        }
        this.sourceLocation = (String)config.get(LOCATION);
        this.field = (String)config.get(FIELD);
        String strDistanceName = (String)config.get(STRING_DISTANCE);
        Object sd = null;
        sd = strDistanceName != null ? (StringDistance)core.getResourceLoader().newInstance(strDistanceName, new String[0]) : new LevensteinDistance();
        try {
            this.initIndex();
            this.spellChecker = new SpellChecker(this.index, (StringDistance)sd);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (accuracy != null) {
            try {
                this.accuracy = Float.parseFloat(accuracy);
                this.spellChecker.setAccuracy(this.accuracy);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Unparseable accuracy given for dictionary: " + this.name, e);
            }
        }
        if (this.field != null && core.getSchema().getFieldTypeNoEx(this.field) != null) {
            this.analyzer = core.getSchema().getFieldType(this.field).getQueryAnalyzer();
        }
        this.fieldTypeName = (String)config.get(FIELD_TYPE);
        if (core.getSchema().getFieldTypes().containsKey(this.fieldTypeName)) {
            FieldType fieldType = core.getSchema().getFieldTypes().get(this.fieldTypeName);
            this.analyzer = fieldType.getQueryAnalyzer();
        }
        if (this.analyzer == null) {
            LOG.info("Using WhitespaceAnalzyer for dictionary: " + this.name);
            this.analyzer = new WhitespaceAnalyzer();
        }
        return this.name;
    }

    @Override
    public SpellingResult getSuggestions(Collection<Token> tokens, IndexReader reader, int count, boolean onlyMorePopular, boolean extendedResults) throws IOException {
        SpellingResult result = new SpellingResult(tokens);
        reader = this.determineReader(reader);
        Term term = this.field != null ? new Term(this.field, "") : null;
        for (Token token : tokens) {
            String tokenText = new String(token.termBuffer(), 0, token.termLength());
            String[] suggestions = this.spellChecker.suggestSimilar(tokenText, Math.max(count, 5), (IndexReader)(this.field != null ? reader : null), this.field, onlyMorePopular);
            if (suggestions.length == 1 && suggestions[0].equals(tokenText)) continue;
            if (extendedResults && reader != null && this.field != null) {
                term = term.createTerm(tokenText);
                result.add(token, reader.docFreq(term));
                int countLimit = Math.min(count, suggestions.length);
                for (int i = 0; i < countLimit; ++i) {
                    term = term.createTerm(suggestions[i]);
                    result.add(token, suggestions[i], reader.docFreq(term));
                }
                continue;
            }
            if (suggestions.length <= 0) continue;
            List<String> suggList = Arrays.asList(suggestions);
            if (suggestions.length > count) {
                suggList = suggList.subList(0, count);
            }
            result.add(token, suggList);
        }
        return result;
    }

    protected IndexReader determineReader(IndexReader reader) {
        return reader;
    }

    @Override
    public void reload() throws IOException {
        this.spellChecker.setSpellIndex(this.index);
    }

    protected void initIndex() throws IOException {
        this.index = this.indexDir != null ? FSDirectory.getDirectory((String)this.indexDir) : new RAMDirectory();
    }

    public float getAccuracy() {
        return this.accuracy;
    }

    public String getField() {
        return this.field;
    }

    public String getFieldTypeName() {
        return this.fieldTypeName;
    }

    public String getIndexDir() {
        return this.indexDir;
    }

    public String getSourceLocation() {
        return this.sourceLocation;
    }
}

