/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.XML;
import org.apache.solr.core.Config;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.schema.IndexSchema;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreContainer {
    protected static Logger log = Logger.getLogger(CoreContainer.class.getName());
    protected final Map<String, SolrCore> cores = new LinkedHashMap<String, SolrCore>();
    protected boolean persistent = false;
    protected String adminPath = null;
    protected String managementPath = null;
    protected CoreAdminHandler coreAdminHandler = null;
    protected File configFile = null;
    protected String libDir = null;
    protected ClassLoader libLoader = null;
    protected SolrResourceLoader loader = null;
    protected WeakReference<SolrCore> adminCore = null;
    protected Properties containerProperties;

    public CoreContainer() {
    }

    public Properties getContainerProperties() {
        return this.containerProperties;
    }

    public CoreContainer(String dir, File configFile) throws ParserConfigurationException, IOException, SAXException {
        this.load(dir, configFile);
    }

    public CoreContainer(SolrResourceLoader loader) {
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String dir, File configFile) throws ParserConfigurationException, IOException, SAXException {
        this.configFile = configFile;
        this.loader = new SolrResourceLoader(dir);
        FileInputStream cfgis = new FileInputStream(configFile);
        try {
            Config cfg = new Config(this.loader, null, cfgis, null);
            this.persistent = cfg.getBool("solr/@persistent", false);
            this.libDir = cfg.get("solr/@sharedLib", null);
            this.adminPath = cfg.get("solr/cores/@adminPath", null);
            this.managementPath = cfg.get("solr/cores/@managementPath", null);
            if (this.libDir != null) {
                File f = new File(dir, this.libDir);
                this.libDir = f.getPath();
                log.info("loading shared library: " + f.getAbsolutePath());
                this.libLoader = SolrResourceLoader.createClassLoader(f, null);
            }
            if (this.adminPath != null) {
                this.coreAdminHandler = this.createMultiCoreHandler();
            }
            try {
                this.containerProperties = this.readProperties(cfg, ((NodeList)cfg.evaluate("solr", XPathConstants.NODESET)).item(0));
            }
            catch (Throwable e) {
                SolrConfig.severeErrors.add(e);
                SolrException.logOnce((Logger)log, null, (Throwable)e);
            }
            NodeList nodes = (NodeList)cfg.evaluate("solr/cores/core", XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                try {
                    String names = DOMUtil.getAttr((Node)node, (String)"name", null);
                    List aliases = StrUtils.splitSmart((String)names, (char)',');
                    String name = (String)aliases.get(0);
                    CoreDescriptor p = new CoreDescriptor(this, name, DOMUtil.getAttr((Node)node, (String)"instanceDir", null));
                    p.setCoreProperties(this.readProperties(cfg, node));
                    String opt = DOMUtil.getAttr((Node)node, (String)"config", null);
                    if (opt != null) {
                        p.setConfigName(opt);
                    }
                    if ((opt = DOMUtil.getAttr((Node)node, (String)"schema", null)) != null) {
                        p.setSchemaName(opt);
                    }
                    SolrCore core = this.create(p);
                    for (int a = 1; a < aliases.size(); ++a) {
                        core.open();
                        this.register((String)aliases.get(a), core, false);
                    }
                    this.register(name, core, false);
                    continue;
                }
                catch (Throwable ex) {
                    SolrConfig.severeErrors.add(ex);
                    SolrException.logOnce((Logger)log, null, (Throwable)ex);
                }
            }
        }
        finally {
            if (cfgis != null) {
                try {
                    cfgis.close();
                }
                catch (Exception xany) {}
            }
        }
    }

    private Properties readProperties(Config cfg, Node node) throws XPathExpressionException {
        XPath xpath = cfg.getXPath();
        NodeList props = (NodeList)xpath.evaluate("property", node, XPathConstants.NODESET);
        Properties properties = new Properties();
        for (int i = 0; i < props.getLength(); ++i) {
            Node prop = props.item(i);
            properties.setProperty(DOMUtil.getAttr((Node)prop, (String)"name"), DOMUtil.getAttr((Node)prop, (String)"value"));
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            for (SolrCore core : this.cores.values()) {
                core.close();
            }
            this.cores.clear();
        }
    }

    protected void finalize() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore register(String name, SolrCore core, boolean returnPrev) {
        if (core == null) {
            throw new RuntimeException("Can not register a null core.");
        }
        if (name == null || name.indexOf(47) >= 0 || name.indexOf(92) >= 0) {
            throw new RuntimeException("Invalid core name: " + name);
        }
        SolrCore old = null;
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            old = this.cores.put(name, core);
            core.setName(name);
        }
        if (old == null || old == core) {
            log.info("registering core: " + name);
            return null;
        }
        log.info("replacing core: " + name);
        if (!returnPrev) {
            old.close();
        }
        return old;
    }

    public SolrCore create(CoreDescriptor dcore) throws ParserConfigurationException, IOException, SAXException {
        File idir = new File(dcore.getInstanceDir());
        if (!idir.isAbsolute()) {
            idir = new File(this.loader.getInstanceDir(), dcore.getInstanceDir());
        }
        String instanceDir = idir.getPath();
        SolrResourceLoader solrLoader = new SolrResourceLoader(instanceDir, this.libLoader, dcore.getCoreProperties());
        SolrConfig config = new SolrConfig(solrLoader, dcore.getConfigName(), null);
        IndexSchema schema = new IndexSchema(config, dcore.getSchemaName(), null);
        SolrCore core = new SolrCore(dcore.getName(), null, config, schema, dcore);
        return core;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SolrCore> getCores() {
        ArrayList<SolrCore> lst = new ArrayList<SolrCore>();
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            lst.addAll(this.cores.values());
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getCoreNames() {
        ArrayList<String> lst = new ArrayList<String>();
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            lst.addAll(this.cores.keySet());
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getCoreNames(SolrCore core) {
        ArrayList<String> lst = new ArrayList<String>();
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            for (Map.Entry<String, SolrCore> entry : this.cores.entrySet()) {
                if (core != entry.getValue()) continue;
                lst.add(entry.getKey());
            }
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(String name) throws ParserConfigurationException, IOException, SAXException {
        SolrCore core;
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            core = this.cores.get(name);
        }
        if (core == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + name);
        }
        SolrCore newCore = this.create(core.getCoreDescriptor());
        for (String alias : this.getCoreNames(core)) {
            if (name.equals(alias)) continue;
            newCore.open();
            this.register(alias, newCore, false);
        }
        this.register(name, newCore, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swap(String n0, String n1) {
        if (n0 == null || n1 == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not swap unnamed cores.");
        }
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            SolrCore c0 = this.cores.get(n0);
            SolrCore c1 = this.cores.get(n1);
            if (c0 == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + n0);
            }
            if (c1 == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + n1);
            }
            this.cores.put(n0, c1);
            this.cores.put(n1, c0);
            c0.setName(n1);
            c1.setName(n0);
        }
        log.info("swaped: " + n0 + " with " + n1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore remove(String name) {
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            return this.cores.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore getCore(String name) {
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            SolrCore core = this.cores.get(name);
            if (core != null) {
                core.open();
            }
            return core;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAdminCore(SolrCore core) {
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            this.adminCore = new WeakReference<SolrCore>(core);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore getAdminCore() {
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            SolrCore core;
            SolrCore solrCore = core = this.adminCore != null ? (SolrCore)this.adminCore.get() : null;
            if (core != null && !core.isClosed()) {
                core.open();
            } else {
                for (SolrCore c : this.cores.values()) {
                    if (c == null) continue;
                    core = c;
                    core.open();
                    this.setAdminCore(core);
                    break;
                }
            }
            return core;
        }
    }

    protected CoreAdminHandler createMultiCoreHandler() {
        return new CoreAdminHandler(){

            public CoreContainer getCoreContainer() {
                return CoreContainer.this;
            }
        };
    }

    public CoreAdminHandler getMultiCoreHandler() {
        return this.coreAdminHandler;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public String getAdminPath() {
        return this.adminPath;
    }

    public void setAdminPath(String adminPath) {
        this.adminPath = adminPath;
    }

    public String getManagementPath() {
        return this.managementPath;
    }

    public void setManagementPath(String path) {
        this.managementPath = path;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void persist() {
        this.persistFile(null);
    }

    public void persistFile(File file) {
        log.info("Persisting cores config to " + (file == null ? this.configFile : file));
        File tmpFile = null;
        try {
            if (file == null) {
                file = tmpFile = File.createTempFile("solr", ".xml", this.configFile.getParentFile());
            }
            FileOutputStream out = new FileOutputStream(file);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            this.persist(writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            out.close();
            if (tmpFile != null) {
                if (tmpFile.renameTo(this.configFile)) {
                    tmpFile = null;
                } else {
                    CoreContainer.fileCopy(tmpFile, this.configFile);
                }
            }
        }
        catch (FileNotFoundException xnf) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)xnf);
        }
        catch (IOException xio) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)xio);
        }
        finally {
            if (tmpFile != null && !tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persist(Writer writer) throws IOException {
        writer.write("<?xml version='1.0' encoding='UTF-8'?>");
        writer.write("<solr");
        if (this.libDir != null) {
            writer.write(" sharedLib='");
            XML.escapeAttributeValue((String)this.libDir, (Writer)writer);
            writer.write(39);
        }
        writer.write(" persistent='");
        if (this.isPersistent()) {
            writer.write("true'");
        } else {
            writer.write("false'");
        }
        writer.write(">\n");
        if (this.containerProperties != null && !this.containerProperties.isEmpty()) {
            this.writeProperties(writer, this.containerProperties);
        }
        writer.write("<cores adminPath='");
        XML.escapeAttributeValue((String)this.adminPath, (Writer)writer);
        writer.write(39);
        writer.write(">\n");
        HashMap aliases = new HashMap();
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            for (Map.Entry<String, SolrCore> entry : this.cores.entrySet()) {
                String name = entry.getKey();
                LinkedList<String> a = (LinkedList<String>)aliases.get(entry.getValue());
                if (a == null) {
                    a = new LinkedList<String>();
                }
                if (name.equals(entry.getValue().getName())) {
                    a.addFirst(name);
                } else {
                    a.addLast(name);
                }
                aliases.put(entry.getValue(), a);
            }
        }
        for (Map.Entry entry : aliases.entrySet()) {
            this.persist(writer, (List)entry.getValue(), ((SolrCore)entry.getKey()).getCoreDescriptor());
        }
        writer.write("</cores>\n");
        writer.write("</solr>\n");
    }

    void persist(Writer writer, List<String> aliases, CoreDescriptor dcore) throws IOException {
        writer.write("  <core");
        writer.write(" name='");
        XML.escapeAttributeValue((String)StrUtils.join(aliases, (char)','), (Writer)writer);
        writer.write("' instanceDir='");
        XML.escapeAttributeValue((String)dcore.getInstanceDir(), (Writer)writer);
        writer.write(39);
        String opt = dcore.getConfigName();
        if (opt != null && !opt.equals(dcore.getDefaultConfigName())) {
            writer.write(" config='");
            XML.escapeAttributeValue((String)opt, (Writer)writer);
            writer.write(39);
        }
        if ((opt = dcore.getSchemaName()) != null && !opt.equals(dcore.getDefaultSchemaName())) {
            writer.write(" schema='");
            XML.escapeAttributeValue((String)opt, (Writer)writer);
            writer.write(39);
        }
        if (dcore.getCoreProperties() == null || dcore.getCoreProperties().isEmpty()) {
            writer.write("/>\n");
        } else {
            writer.write(">\n");
            this.writeProperties(writer, dcore.getCoreProperties());
            writer.write("</core>");
        }
    }

    private void writeProperties(Writer writer, Properties props) throws IOException {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            writer.write("<property name='");
            XML.escapeAttributeValue((String)entry.getKey().toString(), (Writer)writer);
            writer.write("' value='");
            XML.escapeAttributeValue((String)entry.getValue().toString(), (Writer)writer);
            writer.write("' />\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void fileCopy(File src, File dest) throws IOException {
        IOException xforward;
        block39: {
            IOException xio222222;
            AbstractInterruptibleChannel fcout;
            AbstractInterruptibleChannel fcin;
            FileOutputStream fos;
            FileInputStream fis;
            block33: {
                xforward = null;
                fis = null;
                fos = null;
                fcin = null;
                fcout = null;
                fis = new FileInputStream(src);
                fos = new FileOutputStream(dest);
                fcin = fis.getChannel();
                fcout = fos.getChannel();
                int MB32 = 0x2000000;
                long size = ((FileChannel)fcin).size();
                for (long position = 0L; position < size; position += ((FileChannel)fcin).transferTo(position, 0x2000000L, (WritableByteChannel)((Object)fcout))) {
                }
                Object var13_11 = null;
                if (fis == null) break block33;
                try {
                    fis.close();
                    fis = null;
                }
                catch (IOException xio222222) {
                    // empty catch block
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                    fos = null;
                }
                catch (IOException xio222222) {
                    // empty catch block
                }
            }
            if (fcin != null && fcin.isOpen()) {
                try {
                    fcin.close();
                    fcin = null;
                }
                catch (IOException xio222222) {
                    // empty catch block
                }
            }
            if (fcout != null && fcout.isOpen()) {
                try {
                    fcout.close();
                    fcout = null;
                }
                catch (IOException xio222222) {}
            }
            break block39;
            {
                catch (IOException xio3) {
                    IOException xio222222;
                    xforward = xio3;
                    Object var13_12 = null;
                    if (fis != null) {
                        try {
                            fis.close();
                            fis = null;
                        }
                        catch (IOException xio222222) {
                            // empty catch block
                        }
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                            fos = null;
                        }
                        catch (IOException xio222222) {
                            // empty catch block
                        }
                    }
                    if (fcin != null && fcin.isOpen()) {
                        try {
                            fcin.close();
                            fcin = null;
                        }
                        catch (IOException xio222222) {
                            // empty catch block
                        }
                    }
                    if (fcout != null && fcout.isOpen()) {
                        try {
                            fcout.close();
                            fcout = null;
                        }
                        catch (IOException xio222222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException xio222222;
                Object var13_13 = null;
                if (fis != null) {
                    try {
                        fis.close();
                        fis = null;
                    }
                    catch (IOException xio222222) {
                        // empty catch block
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                        fos = null;
                    }
                    catch (IOException xio222222) {
                        // empty catch block
                    }
                }
                if (fcin != null && fcin.isOpen()) {
                    try {
                        fcin.close();
                        fcin = null;
                    }
                    catch (IOException xio222222) {
                        // empty catch block
                    }
                }
                if (fcout != null && fcout.isOpen()) {
                    try {
                        fcout.close();
                        fcout = null;
                    }
                    catch (IOException xio222222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        if (xforward != null) {
            throw xforward;
        }
    }

    public static class Initializer {
        protected String solrConfigFilename = null;
        protected boolean abortOnConfigurationError = true;

        public boolean isAbortOnConfigurationError() {
            return this.abortOnConfigurationError;
        }

        public void setAbortOnConfigurationError(boolean abortOnConfigurationError) {
            this.abortOnConfigurationError = abortOnConfigurationError;
        }

        public String getSolrConfigFilename() {
            return this.solrConfigFilename;
        }

        public void setSolrConfigFilename(String solrConfigFilename) {
            this.solrConfigFilename = solrConfigFilename;
        }

        public CoreContainer initialize() throws IOException, ParserConfigurationException, SAXException {
            CoreContainer cores = null;
            String instanceDir = SolrResourceLoader.locateInstanceDir();
            File fconf = new File(instanceDir, this.solrConfigFilename == null ? "solr.xml" : this.solrConfigFilename);
            log.info("looking for solr.xml: " + fconf.getAbsolutePath());
            if (fconf.exists()) {
                cores = new CoreContainer();
                cores.load(instanceDir, fconf);
                this.abortOnConfigurationError = false;
                for (SolrCore c : cores.getCores()) {
                    if (!c.getSolrConfig().getBool("abortOnConfigurationError", false)) continue;
                    this.abortOnConfigurationError = true;
                    break;
                }
                this.solrConfigFilename = cores.getConfigFile().getName();
            } else {
                cores = new CoreContainer(new SolrResourceLoader(instanceDir));
                SolrConfig cfg = this.solrConfigFilename == null ? new SolrConfig() : new SolrConfig(this.solrConfigFilename);
                CoreDescriptor dcore = new CoreDescriptor(cores, "", ".");
                SolrCore singlecore = new SolrCore(null, null, cfg, null, dcore);
                this.abortOnConfigurationError = cfg.getBool("abortOnConfigurationError", this.abortOnConfigurationError);
                cores.register("", singlecore, false);
                cores.setPersistent(false);
                this.solrConfigFilename = cfg.getName();
            }
            return cores;
        }
    }
}

