/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.util.Collection;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectXmlRequest
extends SolrRequest {
    final String xml;

    public DirectXmlRequest(String path, String body) {
        super(SolrRequest.METHOD.POST, path);
        this.xml = body;
    }

    @Override
    public Collection<ContentStream> getContentStreams() {
        return ClientUtils.toContentStreams(this.xml, "text/xml; charset=utf-8");
    }

    @Override
    public SolrParams getParams() {
        return null;
    }

    @Override
    public UpdateResponse process(SolrServer server) throws SolrServerException, IOException {
        long startTime = System.currentTimeMillis();
        UpdateResponse res = new UpdateResponse();
        res.setResponse(server.request(this));
        res.setElapsedTime(System.currentTimeMillis() - startTime);
        return res;
    }
}

