/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlhandler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.seasar.dbflute.exception.EntityAlreadyUpdatedException;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.beans.TnPropertyDesc;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.sqlhandler.TnBasicHandler;
import org.seasar.dbflute.util.DfTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TnAbstractAutoHandler
extends TnBasicHandler {
    protected TnBeanMetaData beanMetaData;
    protected Object[] bindVariables;
    protected ValueType[] bindVariableValueTypes;
    protected Timestamp timestamp;
    protected Integer versionNo;
    protected TnPropertyType[] propertyTypes;
    protected boolean optimisticLockHandling;
    protected boolean versionNoAutoIncrementOnMemory;

    public TnAbstractAutoHandler(DataSource dataSource, StatementFactory statementFactory, TnBeanMetaData beanMetaData, TnPropertyType[] propertyTypes) {
        super(dataSource, statementFactory);
        this.beanMetaData = beanMetaData;
        this.propertyTypes = propertyTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Object[] args) {
        Connection connection = this.getConnection();
        try {
            int n = this.execute(connection, args[0]);
            return n;
        }
        finally {
            this.close(connection);
        }
    }

    public int execute(Object[] args, Class<?>[] argTypes) {
        return this.execute(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int execute(Connection connection, Object bean) {
        this.preUpdateBean(bean);
        this.setupBindVariables(bean);
        this.logSql(this.bindVariables, this.getArgTypes(this.bindVariables));
        PreparedStatement ps = this.prepareStatement(connection);
        int ret = -1;
        try {
            this.bindArgs(ps, this.bindVariables, this.bindVariableValueTypes);
            ret = this.executeUpdate(ps);
        }
        finally {
            this.close(ps);
        }
        if (this.optimisticLockHandling && ret != 1) {
            throw this.createEntityAlreadyUpdatedException(bean, ret);
        }
        this.postUpdateBean(bean, ret);
        return ret;
    }

    protected void bindArgs(PreparedStatement ps, Object[] args, ValueType[] valueTypes) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            ValueType valueType = valueTypes[i];
            try {
                valueType.bindValue(ps, i + 1, args[i]);
                continue;
            }
            catch (SQLException e) {
                this.handleSQLException(e, ps);
            }
        }
    }

    protected EntityAlreadyUpdatedException createEntityAlreadyUpdatedException(Object bean, int rows) {
        return new EntityAlreadyUpdatedException(bean, rows);
    }

    protected void preUpdateBean(Object bean) {
    }

    protected void postUpdateBean(Object bean, int ret) {
    }

    protected abstract void setupBindVariables(Object var1);

    protected void setupInsertBindVariables(Object bean) {
        ArrayList<Object> varList = new ArrayList<Object>();
        ArrayList<ValueType> varValueTypeList = new ArrayList<ValueType>();
        TnBeanMetaData bmd = this.getBeanMetaData();
        String timestampPropertyName = bmd.getTimestampPropertyName();
        String versionNoPropertyName = bmd.getVersionNoPropertyName();
        for (int i = 0; i < this.propertyTypes.length; ++i) {
            TnPropertyType pt = this.propertyTypes[i];
            if (pt.getPropertyName().equalsIgnoreCase(timestampPropertyName)) {
                this.setTimestamp(ResourceContext.getAccessTimestamp());
                varList.add(this.getTimestamp());
            } else if (pt.getPropertyName().equalsIgnoreCase(versionNoPropertyName)) {
                this.setVersionNo(0);
                varList.add(this.getVersionNo());
            } else {
                varList.add(pt.getPropertyDesc().getValue(bean));
            }
            varValueTypeList.add(pt.getValueType());
        }
        this.setBindVariables(varList.toArray());
        this.setBindVariableValueTypes(varValueTypeList.toArray(new ValueType[varValueTypeList.size()]));
    }

    protected void setupUpdateBindVariables(Object bean) {
        ArrayList<Object> varList = new ArrayList<Object>();
        ArrayList<ValueType> varValueTypeList = new ArrayList<ValueType>();
        TnBeanMetaData bmd = this.getBeanMetaData();
        String timestampPropertyName = bmd.getTimestampPropertyName();
        String versionNoPropertyName = bmd.getVersionNoPropertyName();
        for (int i = 0; i < this.propertyTypes.length; ++i) {
            TnPropertyType pt = this.propertyTypes[i];
            if (pt.getPropertyName().equalsIgnoreCase(timestampPropertyName)) {
                this.setTimestamp(ResourceContext.getAccessTimestamp());
                varList.add(this.getTimestamp());
            } else if (pt.getPropertyName().equalsIgnoreCase(versionNoPropertyName)) {
                Object value;
                if (!this.isVersionNoAutoIncrementOnMemory() || (value = pt.getPropertyDesc().getValue(bean)) == null) continue;
                int intValue = DfTypeUtil.toPrimitiveInt(value) + 1;
                this.setVersionNo(intValue);
                varList.add(this.getVersionNo());
            } else {
                varList.add(pt.getPropertyDesc().getValue(bean));
            }
            varValueTypeList.add(pt.getValueType());
        }
        this.addAutoUpdateWhereBindVariables(varList, varValueTypeList, bean);
        this.setBindVariables(varList.toArray());
        this.setBindVariableValueTypes(varValueTypeList.toArray(new ValueType[varValueTypeList.size()]));
    }

    protected void setupDeleteBindVariables(Object bean) {
        ArrayList<Object> varList = new ArrayList<Object>();
        ArrayList<ValueType> varValueTypeList = new ArrayList<ValueType>();
        this.addAutoUpdateWhereBindVariables(varList, varValueTypeList, bean);
        this.setBindVariables(varList.toArray());
        this.setBindVariableValueTypes(varValueTypeList.toArray(new ValueType[varValueTypeList.size()]));
    }

    protected void addAutoUpdateWhereBindVariables(List<Object> varList, List<ValueType> varValueTypeList, Object bean) {
        TnPropertyDesc pd;
        TnBeanMetaData bmd = this.getBeanMetaData();
        for (int i = 0; i < bmd.getPrimaryKeySize(); ++i) {
            TnPropertyType pt = bmd.getPropertyTypeByColumnName(bmd.getPrimaryKey(i));
            TnPropertyDesc pd2 = pt.getPropertyDesc();
            varList.add(pd2.getValue(bean));
            varValueTypeList.add(pt.getValueType());
        }
        if (this.optimisticLockHandling && bmd.hasVersionNoPropertyType()) {
            TnPropertyType pt = bmd.getVersionNoPropertyType();
            pd = pt.getPropertyDesc();
            varList.add(pd.getValue(bean));
            varValueTypeList.add(pt.getValueType());
        }
        if (this.optimisticLockHandling && bmd.hasTimestampPropertyType()) {
            TnPropertyType pt = bmd.getTimestampPropertyType();
            pd = pt.getPropertyDesc();
            varList.add(pd.getValue(bean));
            varValueTypeList.add(pt.getValueType());
        }
    }

    protected void updateTimestampIfNeed(Object bean) {
        if (this.getTimestamp() != null) {
            TnPropertyDesc pd = this.getBeanMetaData().getTimestampPropertyType().getPropertyDesc();
            pd.setValue(bean, this.getTimestamp());
        }
    }

    protected void updateVersionNoIfNeed(Object bean) {
        if (this.getVersionNo() != null) {
            TnPropertyDesc pd = this.getBeanMetaData().getVersionNoPropertyType().getPropertyDesc();
            pd.setValue(bean, this.getVersionNo());
        }
    }

    public TnBeanMetaData getBeanMetaData() {
        return this.beanMetaData;
    }

    protected Object[] getBindVariables() {
        return this.bindVariables;
    }

    protected void setBindVariables(Object[] bindVariables) {
        this.bindVariables = bindVariables;
    }

    protected ValueType[] getBindVariableValueTypes() {
        return this.bindVariableValueTypes;
    }

    protected void setBindVariableValueTypes(ValueType[] bindVariableValueTypes) {
        this.bindVariableValueTypes = bindVariableValueTypes;
    }

    protected Timestamp getTimestamp() {
        return this.timestamp;
    }

    protected void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    protected Integer getVersionNo() {
        return this.versionNo;
    }

    protected void setVersionNo(Integer versionNo) {
        this.versionNo = versionNo;
    }

    protected TnPropertyType[] getPropertyTypes() {
        return this.propertyTypes;
    }

    protected void setPropertyTypes(TnPropertyType[] propertyTypes) {
        this.propertyTypes = propertyTypes;
    }

    public boolean isOptimisticLockHandling() {
        return this.optimisticLockHandling;
    }

    public void setOptimisticLockHandling(boolean optimisticLockHandling) {
        this.optimisticLockHandling = optimisticLockHandling;
    }

    protected boolean isVersionNoAutoIncrementOnMemory() {
        return this.versionNoAutoIncrementOnMemory;
    }

    public void setVersionNoAutoIncrementOnMemory(boolean versionNoAutoIncrementOnMemory) {
        this.versionNoAutoIncrementOnMemory = versionNoAutoIncrementOnMemory;
    }
}

