/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.metadata.impl;

import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.s2dao.beans.TnBeanDesc;
import org.seasar.dbflute.s2dao.beans.TnPropertyDesc;
import org.seasar.dbflute.s2dao.beans.factory.TnBeanDescFactory;
import org.seasar.dbflute.s2dao.metadata.TnBeanAnnotationReader;
import org.seasar.dbflute.s2dao.metadata.impl.TnFieldBeanAnnotationReader;
import org.seasar.dbflute.util.DfReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnDBMetaBeanAnnotationReader
implements TnBeanAnnotationReader {
    public String VALUE_TYPE_SUFFIX = "_VALUE_TYPE";
    protected final Class<?> beanClass;
    protected final boolean simpleType;
    protected final TnFieldBeanAnnotationReader fieldBeanAnnotationReader;
    protected final DBMeta dbmeta;
    protected final TnBeanDesc beanDesc;

    public TnDBMetaBeanAnnotationReader(Class<?> beanClass) {
        this.beanClass = beanClass;
        this.simpleType = this.isSimpleType(beanClass);
        if (this.simpleType) {
            this.dbmeta = null;
            this.beanDesc = null;
            this.fieldBeanAnnotationReader = null;
            return;
        }
        if (!Entity.class.isAssignableFrom(beanClass)) {
            this.fieldBeanAnnotationReader = new TnFieldBeanAnnotationReader(beanClass);
            this.dbmeta = null;
            this.beanDesc = null;
        } else {
            this.fieldBeanAnnotationReader = null;
            this.dbmeta = ((Entity)DfReflectionUtil.newInstance(beanClass)).getDBMeta();
            this.beanDesc = TnBeanDescFactory.getBeanDesc(beanClass);
        }
    }

    protected boolean isSimpleType(Class<?> clazz) {
        return clazz == String.class || clazz.isPrimitive() || clazz == Boolean.class || clazz == Character.class || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || Calendar.class.isAssignableFrom(clazz);
    }

    @Override
    public String getColumnAnnotation(TnPropertyDesc pd) {
        if (this.simpleType) {
            return null;
        }
        if (this.fieldBeanAnnotationReader != null) {
            return this.fieldBeanAnnotationReader.getColumnAnnotation(pd);
        }
        if (!this.dbmeta.hasColumn(pd.getPropertyName())) {
            return null;
        }
        return this.dbmeta.findColumnInfo(pd.getPropertyName()).getColumnDbName();
    }

    @Override
    public String getTableAnnotation() {
        if (this.simpleType) {
            return null;
        }
        if (this.fieldBeanAnnotationReader != null) {
            return this.fieldBeanAnnotationReader.getTableAnnotation();
        }
        return this.dbmeta.getTableDbName();
    }

    @Override
    public String getVersionNoPropertyName() {
        if (this.simpleType) {
            return null;
        }
        if (this.fieldBeanAnnotationReader != null) {
            return this.fieldBeanAnnotationReader.getVersionNoPropertyName();
        }
        if (!this.dbmeta.hasVersionNo()) {
            return null;
        }
        return this.dbmeta.getVersionNoColumnInfo().getPropertyName();
    }

    @Override
    public String getTimestampPropertyName() {
        if (this.simpleType) {
            return null;
        }
        if (this.fieldBeanAnnotationReader != null) {
            return this.fieldBeanAnnotationReader.getTimestampPropertyName();
        }
        if (!this.dbmeta.hasUpdateDate()) {
            return null;
        }
        return this.dbmeta.getUpdateDateColumnInfo().getPropertyName();
    }

    @Override
    public String getId(TnPropertyDesc pd) {
        if (this.simpleType) {
            return null;
        }
        if (this.fieldBeanAnnotationReader != null) {
            return this.fieldBeanAnnotationReader.getId(pd);
        }
        if (!this.dbmeta.hasColumn(pd.getPropertyName())) {
            return null;
        }
        ColumnInfo columnInfo = this.dbmeta.findColumnInfo(pd.getPropertyName());
        if (this.dbmeta.hasIdentity() && columnInfo.isAutoIncrement()) {
            return "identity";
        }
        return null;
    }

    @Override
    public String getRelationKey(TnPropertyDesc pd) {
        if (this.simpleType) {
            return null;
        }
        if (this.fieldBeanAnnotationReader != null) {
            return this.fieldBeanAnnotationReader.getRelationKey(pd);
        }
        if (!this.dbmeta.hasForeign(pd.getPropertyName())) {
            return null;
        }
        ForeignInfo foreignInfo = this.dbmeta.findForeignInfo(pd.getPropertyName());
        Map<ColumnInfo, ColumnInfo> localForeignColumnInfoMap = foreignInfo.getLocalForeignColumnInfoMap();
        Set<ColumnInfo> keySet = localForeignColumnInfoMap.keySet();
        StringBuilder sb = new StringBuilder();
        for (ColumnInfo localColumnInfo : keySet) {
            ColumnInfo foreignColumnInfo = localForeignColumnInfoMap.get(localColumnInfo);
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(localColumnInfo.getColumnDbName());
            sb.append(":").append(foreignColumnInfo.getColumnDbName());
        }
        return sb.toString();
    }

    @Override
    public int getRelationNo(TnPropertyDesc pd) {
        if (this.simpleType) {
            return 0;
        }
        if (this.fieldBeanAnnotationReader != null) {
            return this.fieldBeanAnnotationReader.getRelationNo(pd);
        }
        ForeignInfo foreignInfo = this.dbmeta.findForeignInfo(pd.getPropertyName());
        return foreignInfo.getRelationNo();
    }

    @Override
    public boolean hasRelationNo(TnPropertyDesc pd) {
        if (this.simpleType) {
            return false;
        }
        if (this.fieldBeanAnnotationReader != null) {
            return this.fieldBeanAnnotationReader.hasRelationNo(pd);
        }
        return this.dbmeta.hasForeign(pd.getPropertyName());
    }

    @Override
    public String getValueType(TnPropertyDesc pd) {
        if (this.simpleType) {
            return null;
        }
        if (this.fieldBeanAnnotationReader != null) {
            return this.fieldBeanAnnotationReader.getValueType(pd);
        }
        String valueTypeKey = pd.getPropertyName() + this.VALUE_TYPE_SUFFIX;
        if (this.beanDesc.hasField(valueTypeKey)) {
            Field field = this.beanDesc.getField(valueTypeKey);
            return (String)DfReflectionUtil.getValue(field, null);
        }
        return null;
    }
}

