/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.extension;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.resource.InternalMapContext;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.beans.TnPropertyDesc;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.rowcreator.impl.TnRowCreatorImpl;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnRowCreatorExtension
extends TnRowCreatorImpl {
    private static final Log _log = LogFactory.getLog(TnRowCreatorExtension.class);
    protected static final String DBMETA_CACHE_KEY = "df:DBMetaCache";
    protected DBMeta _dbmeta;
    protected boolean _beanAssignable;

    protected TnRowCreatorExtension() {
    }

    public static TnRowCreatorExtension createRowCreator(Class<?> beanClass) {
        DBMeta dbmeta;
        TnRowCreatorExtension rowCreator = new TnRowCreatorExtension();
        if (beanClass != null && (dbmeta = TnRowCreatorExtension.findDBMetaByClass(beanClass)) != null) {
            rowCreator.setDBMeta(dbmeta);
            rowCreator.setBeanAssignable(TnRowCreatorExtension.isBeanAssignableFromEntity(beanClass, dbmeta.getEntityType()));
        }
        return rowCreator;
    }

    protected static boolean isBeanAssignableFromEntity(Class<?> beanClass, Class<?> entityType) {
        return beanClass.isAssignableFrom(entityType);
    }

    @Override
    public Object createRow(ResultSet rs, Map<String, TnPropertyType> propertyCache, Class<?> beanClass) throws SQLException {
        Object row;
        DBMeta dbmeta;
        if (propertyCache.isEmpty()) {
            String msg = "The propertyCache should not be empty: bean=" + beanClass.getName();
            throw new IllegalStateException(msg);
        }
        Set<String> columnNameSet = propertyCache.keySet();
        String columnName2 = null;
        TnPropertyType pt = null;
        String propertyName = null;
        Map<String, Integer> selectIndexMap = ResourceContext.getSelectIndexMap();
        if (this._dbmeta != null) {
            dbmeta = this._dbmeta;
            row = this._beanAssignable ? dbmeta.newEntity() : this.newBean(beanClass);
        } else {
            row = this.newBean(beanClass);
            dbmeta = TnRowCreatorExtension.findDBMeta(row);
        }
        try {
            if (dbmeta != null) {
                for (String columnName2 : columnNameSet) {
                    pt = propertyCache.get(columnName2);
                    propertyName = pt.getPropertyName();
                    if (dbmeta.hasEntityPropertySetupper(propertyName)) {
                        ValueType valueType = pt.getValueType();
                        Object value = this.getValue(rs, columnName2, valueType, selectIndexMap);
                        dbmeta.setupEntityProperty(propertyName, row, value);
                        continue;
                    }
                    this.registerValueByReflection(rs, row, pt, columnName2, selectIndexMap);
                }
            } else {
                for (String columnName2 : columnNameSet) {
                    pt = propertyCache.get(columnName2);
                    propertyName = pt.getPropertyName();
                    this.registerValueByReflection(rs, row, pt, columnName2, selectIndexMap);
                }
            }
            return row;
        }
        catch (ClassCastException e) {
            if (_log.isWarnEnabled()) {
                String msg = ClassCastException.class.getSimpleName() + " occurred while ResultSet Handling:";
                _log.warn((Object)(msg + " target=" + beanClass.getSimpleName() + "." + propertyName + " dbmeta"));
            }
            this.throwNonsenseClassCastException(row, dbmeta, e);
            return null;
        }
        catch (SQLException e) {
            if (_log.isWarnEnabled()) {
                String msg = SQLException.class.getSimpleName() + " occurred while ResultSet Handling:";
                _log.warn((Object)(msg + " target=" + beanClass.getSimpleName() + "." + propertyName));
            }
            throw e;
        }
    }

    protected void registerValueByReflection(ResultSet rs, Object row, TnPropertyType pt, String columnName, Map<String, Integer> selectIndexMap) throws SQLException {
        ValueType valueType = pt.getValueType();
        Object value = this.getValue(rs, columnName, valueType, selectIndexMap);
        TnPropertyDesc pd = pt.getPropertyDesc();
        pd.setValue(row, value);
    }

    protected Object getValue(ResultSet rs, String columnName, ValueType valueType, Map<String, Integer> selectIndexMap) throws SQLException {
        Object value = selectIndexMap != null ? ResourceContext.getValue(rs, columnName, valueType, selectIndexMap) : valueType.getValue(rs, columnName);
        return value;
    }

    protected void throwNonsenseClassCastException(Object entity, DBMeta dbmeta, ClassCastException e) {
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = msg + "Nonsense ClassCastException occured!" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Advice]" + this.getLineSeparator();
        msg = msg + "This exception may be from ClassLoader Headache about HotDeploy." + this.getLineSeparator();
        msg = msg + "Please add the ignore-package setting to convention.dicon like as follows:" + this.getLineSeparator();
        msg = msg + "  For example:" + this.getLineSeparator();
        msg = msg + "    <initMethod name=\u201daddIgnorePackageName\u201d>" + this.getLineSeparator();
        msg = msg + "        <arg>\u201dcom.example.xxx.dbflute\u201d</arg>" + this.getLineSeparator();
        msg = msg + "    </initMethod>" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Exception Message]" + this.getLineSeparator() + e.getMessage() + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Target Entity]" + this.getLineSeparator() + entity + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Target Entity Class Loader]" + this.getLineSeparator() + entity.getClass().getClassLoader() + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Target DBMeta]" + this.getLineSeparator() + dbmeta + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Target DBMeta Class Loader]" + this.getLineSeparator() + dbmeta.getClass().getClassLoader() + this.getLineSeparator();
        msg = msg + "* * * * * * * * * */";
        throw new NonsenseClassCastException(msg, e);
    }

    public static DBMeta findDBMeta(Object row) {
        return DBMetaCacheHandler.findDBMeta(row);
    }

    public static DBMeta findDBMeta(Class<?> rowType, String tableName) {
        return DBMetaCacheHandler.findDBMeta(rowType, tableName);
    }

    protected static DBMeta findDBMetaByClass(Class<?> beanClass) {
        Object instance = TnRowCreatorExtension.newInstance(beanClass);
        if (!(instance instanceof Entity)) {
            return null;
        }
        return ((Entity)instance).getDBMeta();
    }

    protected static Object newInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    protected String getLineSeparator() {
        return DfSystemUtil.getLineSeparator();
    }

    public void setDBMeta(DBMeta dbmeta) {
        this._dbmeta = dbmeta;
    }

    public void setBeanAssignable(boolean beanAssignable) {
        this._beanAssignable = beanAssignable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DBMetaCacheHandler {
        protected static final String DBMETA_CACHE_KEY = "df:DBMetaCache";

        protected DBMetaCacheHandler() {
        }

        public static DBMeta findDBMeta(Object row) {
            if (!(row instanceof Entity)) {
                return null;
            }
            Entity entity = (Entity)row;
            DBMeta dbmeta = DBMetaCacheHandler.findCachedDBMeta(entity.getClass());
            if (dbmeta != null) {
                return dbmeta;
            }
            dbmeta = entity.getDBMeta();
            DBMetaCacheHandler.cacheDBMeta(entity, dbmeta);
            return dbmeta;
        }

        public static DBMeta findDBMeta(Class<?> rowType, String tableName) {
            DBMeta dbmeta = DBMetaCacheHandler.findCachedDBMeta(rowType);
            if (dbmeta != null) {
                return dbmeta;
            }
            dbmeta = ResourceContext.provideDBMeta(tableName);
            DBMetaCacheHandler.cacheDBMeta(rowType, dbmeta);
            return dbmeta;
        }

        protected static DBMeta findCachedDBMeta(Class<?> rowType) {
            Map<Class<?>, DBMeta> dbmetaCache = DBMetaCacheHandler.findDBMetaCache();
            if (dbmetaCache == null) {
                dbmetaCache = new HashMap();
                InternalMapContext.setObject("df:DBMetaCache", dbmetaCache);
            }
            return dbmetaCache.get(rowType);
        }

        protected static void cacheDBMeta(Entity entity, DBMeta dbmeta) {
            DBMetaCacheHandler.cacheDBMeta(entity.getClass(), dbmeta);
        }

        protected static void cacheDBMeta(Class<?> type, DBMeta dbmeta) {
            Map<Class<?>, DBMeta> dbmetaCache = DBMetaCacheHandler.findDBMetaCache();
            dbmetaCache.put(type, dbmeta);
        }

        protected static Map<Class<?>, DBMeta> findDBMetaCache() {
            return (Map)InternalMapContext.getObject("df:DBMetaCache");
        }
    }

    public static class NonsenseClassCastException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public NonsenseClassCastException(String msg, ClassCastException e) {
            super(msg, e);
        }
    }
}

