/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.collection.order.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import org.seasar.dbflute.helper.collection.order.AccordingToOrder;
import org.seasar.dbflute.helper.collection.order.AccordingToOrderIdExtractor;
import org.seasar.dbflute.helper.collection.order.AccordingToOrderOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccordingToOrderImpl
implements AccordingToOrder {
    @Override
    public <ELEMENT_TYPE, ID_TYPE> void order(List<ELEMENT_TYPE> unorderedList, AccordingToOrderOption<ELEMENT_TYPE, ID_TYPE> option) {
        this.assertObjectNotNull("unorderedList", unorderedList);
        if (unorderedList.isEmpty()) {
            return;
        }
        this.assertObjectNotNull("option", option);
        List<ID_TYPE> orderedUniqueIdList = option.getOrderedUniqueIdList();
        this.assertObjectNotNull("option.getOrderedUniqueIdList()", orderedUniqueIdList);
        if (orderedUniqueIdList.isEmpty()) {
            return;
        }
        final AccordingToOrderIdExtractor<ELEMENT_TYPE, ID_TYPE> idExtractor = option.getIdExtractor();
        this.assertObjectNotNull("option.getIdExtractor()", idExtractor);
        final LinkedHashMap<ID_TYPE, Integer> idIndexMap = new LinkedHashMap<ID_TYPE, Integer>();
        int index = 0;
        for (ID_TYPE id : orderedUniqueIdList) {
            if (idIndexMap.containsKey(id)) {
                String msg = "The id was duplicated: id=" + id + " orderedUniqueIdList=" + orderedUniqueIdList;
                throw new IllegalStateException(msg);
            }
            idIndexMap.put(id, index);
            ++index;
        }
        Comparator comp = new Comparator<ELEMENT_TYPE>(){

            @Override
            public int compare(ELEMENT_TYPE o1, ELEMENT_TYPE o2) {
                Object id1 = idExtractor.extractId(o1);
                Object id2 = idExtractor.extractId(o2);
                AccordingToOrderImpl.this.assertObjectNotNull("id1 of " + o1, id1);
                AccordingToOrderImpl.this.assertObjectNotNull("id2 of " + o2, id2);
                Integer index1 = (Integer)idIndexMap.get(id1);
                Integer index2 = (Integer)idIndexMap.get(id2);
                if (index1 != null && index2 != null) {
                    return index1.compareTo(index2);
                }
                if (index1 == null && index2 == null) {
                    return 0;
                }
                return index1 == null ? 1 : -1;
            }
        };
        Collections.sort(unorderedList, comp);
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }
}

