/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.outsidesql;

import java.util.List;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.bhv.core.BehaviorCommand;
import org.seasar.dbflute.bhv.core.BehaviorCommandInvoker;
import org.seasar.dbflute.bhv.core.command.OutsideSqlSelectListCommand;
import org.seasar.dbflute.bhv.outsidesql.OutsideSqlEntityExecutor;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.PagingHandler;
import org.seasar.dbflute.cbean.PagingInvoker;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.ResultBeanBuilder;
import org.seasar.dbflute.jdbc.StatementConfig;
import org.seasar.dbflute.outsidesql.OutsideSqlOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutsideSqlPagingExecutor {
    protected final BehaviorCommandInvoker _behaviorCommandInvoker;
    protected final OutsideSqlOption _outsideSqlOption;
    protected final String _tableDbName;
    protected final DBDef _currentDBDef;
    protected final StatementConfig _defaultStatementConfig;

    public OutsideSqlPagingExecutor(BehaviorCommandInvoker behaviorCommandInvoker, OutsideSqlOption outsideSqlOption, String tableDbName, DBDef currentDBDef, StatementConfig defaultStatementConfig) {
        this._behaviorCommandInvoker = behaviorCommandInvoker;
        this._outsideSqlOption = outsideSqlOption;
        this._tableDbName = tableDbName;
        this._currentDBDef = currentDBDef;
        this._defaultStatementConfig = defaultStatementConfig;
    }

    public <ENTITY> ListResultBean<ENTITY> selectList(String path, PagingBean pmb, Class<ENTITY> entityType) {
        this.setupScrollableCursorIfNeeds();
        List<ENTITY> resultList = this.invoke(this.createSelectListCommand(path, pmb, entityType));
        return new ResultBeanBuilder<ENTITY>(this._tableDbName).buildListResultBean(resultList);
    }

    public <ENTITY> PagingResultBean<ENTITY> selectPage(final String path, final PagingBean pmb, final Class<ENTITY> entityType) {
        final OutsideSqlEntityExecutor<PagingBean> countExecutor = this.createCountExecutor();
        PagingHandler handler = new PagingHandler<ENTITY>(){

            @Override
            public PagingBean getPagingBean() {
                return pmb;
            }

            @Override
            public int count() {
                pmb.xsetPaging(false);
                return countExecutor.selectEntityWithDeletedCheck(path, pmb, Integer.class);
            }

            @Override
            public List<ENTITY> paging() {
                pmb.xsetPaging(true);
                return OutsideSqlPagingExecutor.this.selectList(path, pmb, entityType);
            }
        };
        PagingInvoker invoker = new PagingInvoker(this._tableDbName);
        return invoker.invokePaging(handler);
    }

    protected OutsideSqlEntityExecutor<PagingBean> createCountExecutor() {
        OutsideSqlOption countOption = this._outsideSqlOption.copyOptionWithoutPaging();
        return new OutsideSqlEntityExecutor<PagingBean>(this._behaviorCommandInvoker, countOption, this._tableDbName, this._currentDBDef);
    }

    protected void setupScrollableCursorIfNeeds() {
        if (!this._outsideSqlOption.isAutoPaging()) {
            return;
        }
        StatementConfig statementConfig = this._outsideSqlOption.getStatementConfig();
        if (statementConfig != null && statementConfig.hasResultSetType()) {
            return;
        }
        if (this._defaultStatementConfig != null && this._defaultStatementConfig.hasResultSetType()) {
            return;
        }
        if (statementConfig == null) {
            statementConfig = new StatementConfig();
            this.configure(statementConfig);
        }
        statementConfig.typeScrollInsensitive();
    }

    protected <ENTITY> BehaviorCommand<List<ENTITY>> createSelectListCommand(String path, Object pmb, Class<ENTITY> entityType) {
        return this.xsetupCommand(new OutsideSqlSelectListCommand(), path, pmb, entityType);
    }

    private <ENTITY> OutsideSqlSelectListCommand<ENTITY> xsetupCommand(OutsideSqlSelectListCommand<ENTITY> command, String path, Object pmb, Class<ENTITY> entityType) {
        command.setTableDbName(this._tableDbName);
        this._behaviorCommandInvoker.injectComponentProperty(command);
        command.setOutsideSqlPath(path);
        command.setParameterBean(pmb);
        command.setOutsideSqlOption(this._outsideSqlOption);
        command.setCurrentDBDef(this._currentDBDef);
        command.setEntityType(entityType);
        return command;
    }

    protected <RESULT> RESULT invoke(BehaviorCommand<RESULT> behaviorCommand) {
        return this._behaviorCommandInvoker.invoke(behaviorCommand);
    }

    public OutsideSqlPagingExecutor configure(StatementConfig statementConfig) {
        this._outsideSqlOption.setStatementConfig(statementConfig);
        return this;
    }

    public OutsideSqlPagingExecutor dynamicBinding() {
        this._outsideSqlOption.dynamicBinding();
        return this;
    }
}

