/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.outsidesql;

import java.util.List;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.bhv.core.BehaviorCommand;
import org.seasar.dbflute.bhv.core.BehaviorCommandInvoker;
import org.seasar.dbflute.bhv.core.command.AbstractOutsideSqlCommand;
import org.seasar.dbflute.bhv.core.command.OutsideSqlCallCommand;
import org.seasar.dbflute.bhv.core.command.OutsideSqlExecuteCommand;
import org.seasar.dbflute.bhv.core.command.OutsideSqlSelectListCommand;
import org.seasar.dbflute.bhv.outsidesql.OutsideSqlCursorExecutor;
import org.seasar.dbflute.bhv.outsidesql.OutsideSqlEntityExecutor;
import org.seasar.dbflute.bhv.outsidesql.OutsideSqlPagingExecutor;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.ResultBeanBuilder;
import org.seasar.dbflute.jdbc.StatementConfig;
import org.seasar.dbflute.outsidesql.OutsideSqlOption;
import org.seasar.dbflute.outsidesql.ProcedurePmb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutsideSqlBasicExecutor {
    protected final BehaviorCommandInvoker _behaviorCommandInvoker;
    protected final String _tableDbName;
    protected final DBDef _currentDBDef;
    protected final StatementConfig _defaultStatementConfig;
    protected boolean _dynamicBinding;
    protected StatementConfig _statementConfig;

    public OutsideSqlBasicExecutor(BehaviorCommandInvoker behaviorCommandInvoker, String tableDbName, DBDef currentDBDef, StatementConfig defaultStatementConfig) {
        this._behaviorCommandInvoker = behaviorCommandInvoker;
        this._tableDbName = tableDbName;
        this._currentDBDef = currentDBDef;
        this._defaultStatementConfig = defaultStatementConfig;
    }

    public <ENTITY> ListResultBean<ENTITY> selectList(String path, Object pmb, Class<ENTITY> entityType) {
        List<ENTITY> resultList = this.invoke(this.createSelectListCommand(path, pmb, entityType));
        return new ResultBeanBuilder<ENTITY>(this._tableDbName).buildListResultBean(resultList);
    }

    public int execute(String path, Object pmb) {
        return this.invoke(this.createExecuteCommand(path, pmb));
    }

    public void call(ProcedurePmb pmb) {
        if (pmb == null) {
            throw new IllegalArgumentException("The argument of call() 'pmb' should not be null!");
        }
        this.invoke(this.createCallCommand(pmb.getProcedureName(), pmb));
    }

    protected <ENTITY> BehaviorCommand<List<ENTITY>> createSelectListCommand(String path, Object pmb, Class<ENTITY> entityType) {
        OutsideSqlSelectListCommand<ENTITY> cmd = this.xsetupCommand(new OutsideSqlSelectListCommand(), path, pmb);
        cmd.setEntityType(entityType);
        return cmd;
    }

    protected BehaviorCommand<Integer> createExecuteCommand(String path, Object pmb) {
        return this.xsetupCommand(new OutsideSqlExecuteCommand(), path, pmb);
    }

    protected BehaviorCommand<Void> createCallCommand(String path, Object pmb) {
        return this.xsetupCommand(new OutsideSqlCallCommand(), path, pmb);
    }

    private <COMMAND extends AbstractOutsideSqlCommand<?>> COMMAND xsetupCommand(COMMAND command, String path, Object pmb) {
        command.setTableDbName(this._tableDbName);
        this._behaviorCommandInvoker.injectComponentProperty(command);
        command.setOutsideSqlPath(path);
        command.setParameterBean(pmb);
        command.setOutsideSqlOption(this.createOutsideSqlOption());
        command.setCurrentDBDef(this._currentDBDef);
        return command;
    }

    protected <RESULT> RESULT invoke(BehaviorCommand<RESULT> behaviorCommand) {
        return this._behaviorCommandInvoker.invoke(behaviorCommand);
    }

    public OutsideSqlCursorExecutor<Object> cursorHandling() {
        return new OutsideSqlCursorExecutor<Object>(this._behaviorCommandInvoker, this.createOutsideSqlOption(), this._tableDbName, this._currentDBDef);
    }

    public OutsideSqlEntityExecutor<Object> entityHandling() {
        return new OutsideSqlEntityExecutor<Object>(this._behaviorCommandInvoker, this.createOutsideSqlOption(), this._tableDbName, this._currentDBDef);
    }

    public OutsideSqlPagingExecutor autoPaging() {
        OutsideSqlOption option = this.createOutsideSqlOption();
        option.autoPaging();
        return new OutsideSqlPagingExecutor(this._behaviorCommandInvoker, option, this._tableDbName, this._currentDBDef, this._defaultStatementConfig);
    }

    public OutsideSqlPagingExecutor manualPaging() {
        OutsideSqlOption option = this.createOutsideSqlOption();
        option.manualPaging();
        return new OutsideSqlPagingExecutor(this._behaviorCommandInvoker, option, this._tableDbName, this._currentDBDef, this._defaultStatementConfig);
    }

    public OutsideSqlBasicExecutor dynamicBinding() {
        this._dynamicBinding = true;
        return this;
    }

    public OutsideSqlBasicExecutor configure(StatementConfig statementConfig) {
        this._statementConfig = statementConfig;
        return this;
    }

    protected OutsideSqlOption createOutsideSqlOption() {
        OutsideSqlOption option = new OutsideSqlOption();
        option.setStatementConfig(this._statementConfig);
        if (this._dynamicBinding) {
            option.dynamicBinding();
        }
        option.setTableDbName(this._tableDbName);
        return option;
    }
}

