/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.core.execution;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.outsidesql.OutsideSqlContext;
import org.seasar.dbflute.s2dao.beans.TnBeanDesc;
import org.seasar.dbflute.s2dao.beans.TnPropertyDesc;
import org.seasar.dbflute.s2dao.beans.factory.TnBeanDescFactory;
import org.seasar.dbflute.s2dao.jdbc.TnResultSetHandler;
import org.seasar.dbflute.s2dao.sqlcommand.TnAbstractDynamicCommand;
import org.seasar.dbflute.s2dao.sqlhandler.TnBasicSelectHandler;
import org.seasar.dbflute.twowaysql.context.CommandContext;
import org.seasar.dbflute.util.DfStringUtil;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutsideSqlSelectExecution
extends TnAbstractDynamicCommand {
    protected TnResultSetHandler resultSetHandler;

    public OutsideSqlSelectExecution(DataSource dataSource, StatementFactory statementFactory, TnResultSetHandler resultSetHandler) {
        super(dataSource, statementFactory);
        this.resultSetHandler = resultSetHandler;
    }

    @Override
    public Object execute(Object[] args) {
        OutsideSqlContext outsideSqlContext = OutsideSqlContext.getOutsideSqlContextOnThread();
        if (outsideSqlContext.isDynamicBinding()) {
            return this.executeOutsideSqlAsDynamic(args, outsideSqlContext);
        }
        return this.executeOutsideSqlAsStatic(args, outsideSqlContext);
    }

    protected Object executeOutsideSqlAsDynamic(Object[] args, OutsideSqlContext outsideSqlContext) {
        Object firstArg = args[0];
        String staticSql = this.getSql();
        if (firstArg != null) {
            TnBeanDesc beanDesc = TnBeanDescFactory.getBeanDesc(firstArg.getClass());
            List<String> proppertyNameList = beanDesc.getProppertyNameList();
            for (String proppertyName : proppertyNameList) {
                String outsideSqlPiece;
                TnPropertyDesc propertyDesc = beanDesc.getPropertyDesc(proppertyName);
                Class<?> propertyType = propertyDesc.getPropertyType();
                if (!propertyType.equals(String.class) || (outsideSqlPiece = (String)propertyDesc.getValue(firstArg)) == null) continue;
                String embeddedComment = "/*$pmb." + propertyDesc.getPropertyName() + "*/";
                staticSql = this.replaceString(staticSql, embeddedComment, outsideSqlPiece);
            }
        }
        OutsideSqlSelectExecution outsideSqlCommand = this.createDynamicSqlFactory();
        outsideSqlCommand.setArgNames(this.getArgNames());
        outsideSqlCommand.setArgTypes(this.getArgTypes());
        outsideSqlCommand.setSql(staticSql);
        CommandContext ctx = outsideSqlCommand.apply(args);
        ArrayList<Object> bindVariableList = new ArrayList<Object>();
        ArrayList bindVariableTypeList = new ArrayList();
        this.addBindVariableInfo(ctx, bindVariableList, bindVariableTypeList);
        TnBasicSelectHandler selectHandler = this.createBasicSelectHandler(ctx.getSql(), this.resultSetHandler);
        Object[] bindVariableArray = bindVariableList.toArray();
        selectHandler.setLoggingMessageSqlArgs(bindVariableArray);
        return selectHandler.execute(bindVariableArray, this.toClassArray(bindVariableTypeList));
    }

    protected Object executeOutsideSqlAsStatic(Object[] args, OutsideSqlContext outsideSqlContext) {
        CommandContext ctx = this.apply(args);
        TnBasicSelectHandler selectHandler = this.createBasicSelectHandler(ctx.getSql(), this.resultSetHandler);
        Object[] bindVariableArray = ctx.getBindVariables();
        selectHandler.setLoggingMessageSqlArgs(bindVariableArray);
        return selectHandler.execute(bindVariableArray, ctx.getBindVariableTypes());
    }

    protected OutsideSqlSelectExecution createDynamicSqlFactory() {
        return new OutsideSqlSelectExecution(this.getDataSource(), this.getStatementFactory(), this.resultSetHandler);
    }

    protected TnBasicSelectHandler createBasicSelectHandler(String realSql, TnResultSetHandler rsh) {
        return new TnBasicSelectHandler(this.getDataSource(), realSql, rsh, this.getStatementFactory());
    }

    @Override
    protected boolean isBlockNullParameter() {
        return true;
    }

    protected Class<?>[] toClassArray(List<Class<?>> bindVariableTypeList) {
        Class[] bindVariableTypesArray = new Class[bindVariableTypeList.size()];
        for (int i = 0; i < bindVariableTypeList.size(); ++i) {
            Class<?> bindVariableType;
            bindVariableTypesArray[i] = bindVariableType = bindVariableTypeList.get(i);
        }
        return bindVariableTypesArray;
    }

    protected void addBindVariableInfo(CommandContext ctx, List<Object> bindVariableList, List<Class<?>> bindVariableTypeList) {
        Object[] bindVariables = ctx.getBindVariables();
        this.addBindVariableList(bindVariableList, bindVariables);
        Class<?>[] bindVariableTypes = ctx.getBindVariableTypes();
        this.addBindVariableTypeList(bindVariableTypeList, bindVariableTypes);
    }

    protected void addBindVariableList(List<Object> bindVariableList, Object[] bindVariables) {
        for (int i = 0; i < bindVariables.length; ++i) {
            bindVariableList.add(bindVariables[i]);
        }
    }

    protected void addBindVariableTypeList(List<Class<?>> bindVariableTypeList, Class<?>[] bindVariableTypes) {
        for (int i = 0; i < bindVariableTypes.length; ++i) {
            bindVariableTypeList.add(bindVariableTypes[i]);
        }
    }

    protected final String replaceString(String text, String fromText, String toText) {
        return DfStringUtil.replace(text, fromText, toText);
    }

    protected String getLineSeparator() {
        return DfSystemUtil.getLineSeparator();
    }
}

