/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.PDFTextStripper;
import org.apache.pdfbox.util.TextPosition;
import org.apache.pdfbox.util.operator.OperatorProcessor;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.IOExceptionWithCause;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class PDF2XHTML
extends PDFTextStripper {
    private final XHTMLContentHandler handler;

    public static void process(PDDocument document, ContentHandler handler, Metadata metadata) throws SAXException, TikaException {
        try {
            new PDF2XHTML(handler, metadata).getText(document);
        }
        catch (IOException e) {
            if (e.getCause() instanceof SAXException) {
                throw (SAXException)e.getCause();
            }
            throw new TikaException("Unable to extract PDF content", (Throwable)e);
        }
    }

    private PDF2XHTML(ContentHandler handler, Metadata metadata) throws IOException {
        this.handler = new XHTMLContentHandler(handler, metadata);
        OperatorProcessor ignore = new OperatorProcessor(){

            public void process(PDFOperator operator, List arguments) {
            }
        };
        this.registerOperatorProcessor("b", ignore);
        this.registerOperatorProcessor("B", ignore);
        this.registerOperatorProcessor("b*", ignore);
        this.registerOperatorProcessor("B*", ignore);
        this.registerOperatorProcessor("BDC", ignore);
        this.registerOperatorProcessor("BI", ignore);
        this.registerOperatorProcessor("BMC", ignore);
        this.registerOperatorProcessor("b", ignore);
        this.registerOperatorProcessor("BX", ignore);
        this.registerOperatorProcessor("c", ignore);
        this.registerOperatorProcessor("CS", ignore);
        this.registerOperatorProcessor("cs", ignore);
        this.registerOperatorProcessor("d", ignore);
        this.registerOperatorProcessor("d0", ignore);
        this.registerOperatorProcessor("d1", ignore);
        this.registerOperatorProcessor("DP", ignore);
        this.registerOperatorProcessor("El", ignore);
        this.registerOperatorProcessor("EMC", ignore);
        this.registerOperatorProcessor("EX", ignore);
        this.registerOperatorProcessor("f", ignore);
        this.registerOperatorProcessor("F", ignore);
        this.registerOperatorProcessor("f*", ignore);
        this.registerOperatorProcessor("G", ignore);
        this.registerOperatorProcessor("g", ignore);
        this.registerOperatorProcessor("h", ignore);
        this.registerOperatorProcessor("i", ignore);
        this.registerOperatorProcessor("ID", ignore);
        this.registerOperatorProcessor("j", ignore);
        this.registerOperatorProcessor("J", ignore);
        this.registerOperatorProcessor("K", ignore);
        this.registerOperatorProcessor("k", ignore);
        this.registerOperatorProcessor("l", ignore);
        this.registerOperatorProcessor("m", ignore);
        this.registerOperatorProcessor("M", ignore);
        this.registerOperatorProcessor("MP", ignore);
        this.registerOperatorProcessor("n", ignore);
        this.registerOperatorProcessor("re", ignore);
        this.registerOperatorProcessor("RG", ignore);
        this.registerOperatorProcessor("rg", ignore);
        this.registerOperatorProcessor("ri", ignore);
        this.registerOperatorProcessor("s", ignore);
        this.registerOperatorProcessor("S", ignore);
        this.registerOperatorProcessor("SC", ignore);
        this.registerOperatorProcessor("sc", ignore);
        this.registerOperatorProcessor("SCN", ignore);
        this.registerOperatorProcessor("scn", ignore);
        this.registerOperatorProcessor("sh", ignore);
        this.registerOperatorProcessor("v", ignore);
        this.registerOperatorProcessor("W", ignore);
        this.registerOperatorProcessor("W*", ignore);
        this.registerOperatorProcessor("y", ignore);
    }

    protected void startDocument(PDDocument pdf) throws IOException {
        try {
            this.handler.startDocument();
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a document", (Throwable)e);
        }
    }

    protected void endDocument(PDDocument pdf) throws IOException {
        try {
            this.handler.endDocument();
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a document", (Throwable)e);
        }
    }

    protected void startPage(PDPage page) throws IOException {
        try {
            this.handler.startElement("div", "class", "page");
            this.handler.startElement("p");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a page", (Throwable)e);
        }
    }

    protected void endPage(PDPage page) throws IOException {
        try {
            this.handler.endElement("p");
            this.handler.endElement("div");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a page", (Throwable)e);
        }
    }

    protected void writeString(String text) throws IOException {
        try {
            this.handler.characters(text);
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a string: " + text, (Throwable)e);
        }
    }

    protected void writeCharacters(TextPosition text) throws IOException {
        try {
            this.handler.characters(text.getCharacter());
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a character: " + text.getCharacter(), (Throwable)e);
        }
    }

    public String getWordSeparator() {
        try {
            this.handler.characters(" ");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return super.getWordSeparator();
    }

    public String getLineSeparator() {
        try {
            this.handler.characters("\n");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return super.getLineSeparator();
    }
}

