package jp.sourceforge.projects.ee2e.core.relax;

import java.io.*;
import java.net.URL;
import javax.xml.parsers.*;
import org.xml.sax.*;
import org.w3c.dom.*;

/**
 * <b>EE2RTagext</b> is generated by Relaxer based on ee2e.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="tagext">
 *   <tag>
 *     <attribute name="tagref" type="string"/>
 *     <attribute name="target" type="string"/>
 *   </tag>
 *   <empty/>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="tagext"&gt;
 *   &lt;tag&gt;
 *     &lt;attribute name="tagref" type="string"/&gt;
 *     &lt;attribute name="target" type="string"/&gt;
 *   &lt;/tag&gt;
 *   &lt;empty/&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version ee2e.rlx 1.2 (Tue Apr 29 23:33:18 JST 2003)
 * @author  Relaxer 0.13 (http://www.relaxer.org)
 */
public class EE2RTagext implements java.io.Serializable {
    private String tagref_;
    private String target_;

    /**
     * Creates a <code>EE2RTagext</code>.
     *
     */
    public EE2RTagext() {
    }

    /**
     * Creates a <code>EE2RTagext</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public EE2RTagext(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>EE2RTagext</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public EE2RTagext(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>EE2RTagext</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public EE2RTagext(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>EE2RTagext</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RTagext(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>EE2RTagext</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RTagext(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>EE2RTagext</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RTagext(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>EE2RTagext</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RTagext(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>EE2RTagext</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RTagext(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>EE2RTagext</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RTagext(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>EE2RTagext</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>EE2RTagext</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>EE2RTagext</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        tagref_ = URelaxer.getAttributePropertyAsString(element, "tagref");
        target_ = URelaxer.getAttributePropertyAsString(element, "target");
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("tagext");
        if (this.tagref_ != null) {
            URelaxer.setAttributePropertyByString(element, "tagref", this.tagref_);
        }
        if (this.target_ != null) {
            URelaxer.setAttributePropertyByString(element, "target", this.target_);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>EE2RTagext</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>EE2RTagext</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(uri));
    }

    /**
     * Initializes the <code>EE2RTagext</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(url));
    }

    /**
     * Initializes the <code>EE2RTagext</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(in));
    }

    /**
     * Initializes the <code>EE2RTagext</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(is));
    }

    /**
     * Initializes the <code>EE2RTagext</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(reader));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>tagref</b>.
     *
     * @return String
     */
    public final String getTagref() {
        return (tagref_);
    }

    /**
     * Sets the String property <b>tagref</b>.
     *
     * @param tagref
     */
    public final void setTagref(String tagref) {
        this.tagref_ = tagref;
    }

    /**
     * Gets the String property <b>target</b>.
     *
     * @return String
     */
    public final String getTarget() {
        return (target_);
    }

    /**
     * Sets the String property <b>target</b>.
     *
     * @param target
     */
    public final void setTarget(String target) {
        this.target_ = target;
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<tagext");
        if (tagref_ != null) {
            buffer.append(" tagref=\"");
            buffer.append(URelaxer.escapeAttrQuot(getTagref()));
            buffer.append("\"");
        }
        if (target_ != null) {
            buffer.append(" target=\"");
            buffer.append(URelaxer.escapeAttrQuot(getTarget()));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append("</tagext>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<tagext");
        if (tagref_ != null) {
            buffer.print(" tagref=\"");
            buffer.print(URelaxer.escapeAttrQuot(getTagref()));
            buffer.print("\"");
        }
        if (target_ != null) {
            buffer.print(" target=\"");
            buffer.print(URelaxer.escapeAttrQuot(getTarget()));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print("</tagext>");
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>EE2RTagext</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "tagext")) {
            return (false);
        }
        RStack target = new RStack(element);
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EE2RTagext</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EE2RTagext</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
