package jp.sourceforge.projects.ee2e.core.relax;

import java.io.*;
import java.net.URL;
import javax.xml.parsers.*;
import org.xml.sax.*;
import org.w3c.dom.*;

/**
 * <b>EE2RIterationList</b> is generated by Relaxer based on ee2e.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="iterationList">
 *   <tag>
 *     <attribute name="type" type="string"/>
 *   </tag>
 *   <sequence>
 *     <ref label="iteration" occurs="+"/>
 *   </sequence>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="iterationList"&gt;
 *   &lt;tag&gt;
 *     &lt;attribute name="type" type="string"/&gt;
 *   &lt;/tag&gt;
 *   &lt;sequence&gt;
 *     &lt;ref label="iteration" occurs="+"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version ee2e.rlx 1.2 (Tue Apr 29 23:33:18 JST 2003)
 * @author  Relaxer 0.13 (http://www.relaxer.org)
 */
public class EE2RIterationList implements java.io.Serializable {
    private String type_;
    // List<EE2RIteration>
    private java.util.List iteration_ = new java.util.ArrayList();

    /**
     * Creates a <code>EE2RIterationList</code>.
     *
     */
    public EE2RIterationList() {
    }

    /**
     * Creates a <code>EE2RIterationList</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public EE2RIterationList(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>EE2RIterationList</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public EE2RIterationList(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>EE2RIterationList</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public EE2RIterationList(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>EE2RIterationList</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RIterationList(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>EE2RIterationList</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RIterationList(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>EE2RIterationList</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RIterationList(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>EE2RIterationList</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RIterationList(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>EE2RIterationList</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RIterationList(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>EE2RIterationList</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RIterationList(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>EE2RIterationList</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>EE2RIterationList</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>EE2RIterationList</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        type_ = URelaxer.getAttributePropertyAsString(element, "type");
        iteration_.clear();
        while (!stack.isEmptyElement()) {
            if (EE2RIteration.isMatch(stack)) {
                addIteration(new EE2RIteration(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("iterationList");
        int size;
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        size = this.iteration_.size();
        for (int i = 0;i < size;i++) {
            EE2RIteration value = (EE2RIteration)this.iteration_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>EE2RIterationList</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>EE2RIterationList</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(uri));
    }

    /**
     * Initializes the <code>EE2RIterationList</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(url));
    }

    /**
     * Initializes the <code>EE2RIterationList</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(in));
    }

    /**
     * Initializes the <code>EE2RIterationList</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(is));
    }

    /**
     * Initializes the <code>EE2RIterationList</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(reader));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>type</b>.
     *
     * @return String
     */
    public final String getType() {
        return (type_);
    }

    /**
     * Sets the String property <b>type</b>.
     *
     * @param type
     */
    public final void setType(String type) {
        this.type_ = type;
    }

    /**
     * Gets the EE2RIteration property <b>iteration</b>.
     *
     * @return EE2RIteration[]
     */
    public final EE2RIteration[] getIteration() {
        EE2RIteration[] array = new EE2RIteration[iteration_.size()];
        return ((EE2RIteration[])iteration_.toArray(array));
    }

    /**
     * Sets the EE2RIteration property <b>iteration</b>.
     *
     * @param iteration
     */
    public final void setIteration(EE2RIteration[] iteration) {
        this.iteration_.clear();
        this.iteration_.addAll(java.util.Arrays.asList(iteration));
    }

    /**
     * Sets the EE2RIteration property <b>iteration</b>.
     *
     * @param iteration
     */
    public final void setIteration(EE2RIteration iteration) {
        this.iteration_.clear();
        this.iteration_.add(iteration);
    }

    /**
     * Adds the EE2RIteration property <b>iteration</b>.
     *
     * @param iteration
     */
    public final void addIteration(EE2RIteration iteration) {
        this.iteration_.add(iteration);
    }

    /**
     * Gets number of the EE2RIteration property <b>iteration</b>.
     *
     * @return int
     */
    public final int getIterationCount() {
        return (iteration_.size());
    }

    /**
     * Gets the EE2RIteration property <b>iteration</b> by index.
     *
     * @param index
     * @return EE2RIteration
     */
    public final EE2RIteration getIteration(int index) {
        return ((EE2RIteration)iteration_.get(index));
    }

    /**
     * Sets the EE2RIteration property <b>iteration</b> by index.
     *
     * @param index
     * @param iteration
     */
    public final void setIteration(int index, EE2RIteration iteration) {
        this.iteration_.set(index, iteration);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<iterationList");
        if (type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(getType()));
            buffer.append("\"");
        }
        buffer.append(">");
        size = this.iteration_.size();
        for (int i = 0;i < size;i++) {
            EE2RIteration value = (EE2RIteration)this.iteration_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</iterationList>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<iterationList");
        if (type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(getType()));
            buffer.print("\"");
        }
        buffer.print(">");
        size = this.iteration_.size();
        for (int i = 0;i < size;i++) {
            EE2RIteration value = (EE2RIteration)this.iteration_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</iterationList>");
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>EE2RIterationList</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "iterationList")) {
            return (false);
        }
        RStack target = new RStack(element);
        if (!EE2RIteration.isMatchHungry(target)) {
            return (false);
        }
        while (!target.isEmptyElement()) {
            if (!EE2RIteration.isMatchHungry(target)) {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EE2RIterationList</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EE2RIterationList</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
