package jp.sourceforge.projects.ee2e.core.relax;

import java.io.*;
import java.net.URL;
import javax.xml.parsers.*;
import org.xml.sax.*;
import org.w3c.dom.*;

/**
 * <b>EE2RDefvar</b> is generated by Relaxer based on ee2e.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="defvar">
 *   <tag>
 *     <attribute name="id" type="string"/>
 *   </tag>
 *   <choice occurs="*">
 *     <ref label="tag" occurs="*"/>
 *     <ref label="attribute" occurs="*"/>
 *     <ref label="enumeration" occurs="*"/>
 *   </choice>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="defvar"&gt;
 *   &lt;tag&gt;
 *     &lt;attribute name="id" type="string"/&gt;
 *   &lt;/tag&gt;
 *   &lt;choice occurs="*"&gt;
 *     &lt;ref label="tag" occurs="*"/&gt;
 *     &lt;ref label="attribute" occurs="*"/&gt;
 *     &lt;ref label="enumeration" occurs="*"/&gt;
 *   &lt;/choice&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version ee2e.rlx 1.2 (Tue Apr 29 23:33:18 JST 2003)
 * @author  Relaxer 0.13 (http://www.relaxer.org)
 */
public class EE2RDefvar implements java.io.Serializable {
    private String id_;
    // List<IEE2RDefvarChoice>
    private java.util.List content_ = new java.util.ArrayList();

    /**
     * Creates a <code>EE2RDefvar</code>.
     *
     */
    public EE2RDefvar() {
    }

    /**
     * Creates a <code>EE2RDefvar</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public EE2RDefvar(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>EE2RDefvar</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public EE2RDefvar(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>EE2RDefvar</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public EE2RDefvar(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>EE2RDefvar</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RDefvar(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>EE2RDefvar</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RDefvar(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>EE2RDefvar</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RDefvar(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>EE2RDefvar</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RDefvar(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>EE2RDefvar</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RDefvar(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>EE2RDefvar</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RDefvar(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>EE2RDefvar</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>EE2RDefvar</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>EE2RDefvar</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        id_ = URelaxer.getAttributePropertyAsString(element, "id");
        content_.clear();
        while (!stack.isEmptyElement()) {
            if (EE2RTag.isMatch(stack)) {
                addContent(new EE2RTag(stack));
            } else if (EE2RAttribute.isMatch(stack)) {
                addContent(new EE2RAttribute(stack));
            } else if (EE2REnumeration.isMatch(stack)) {
                addContent(new EE2REnumeration(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("defvar");
        int size;
        if (this.id_ != null) {
            URelaxer.setAttributePropertyByString(element, "id", this.id_);
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IEE2RDefvarChoice value = (IEE2RDefvarChoice)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>EE2RDefvar</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>EE2RDefvar</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(uri));
    }

    /**
     * Initializes the <code>EE2RDefvar</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(url));
    }

    /**
     * Initializes the <code>EE2RDefvar</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(in));
    }

    /**
     * Initializes the <code>EE2RDefvar</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(is));
    }

    /**
     * Initializes the <code>EE2RDefvar</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(reader));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>id</b>.
     *
     * @return String
     */
    public final String getId() {
        return (id_);
    }

    /**
     * Sets the String property <b>id</b>.
     *
     * @param id
     */
    public final void setId(String id) {
        this.id_ = id;
    }

    /**
     * Gets the IEE2RDefvarChoice property <b>content</b>.
     *
     * @return IEE2RDefvarChoice[]
     */
    public final IEE2RDefvarChoice[] getContent() {
        IEE2RDefvarChoice[] array = new IEE2RDefvarChoice[content_.size()];
        return ((IEE2RDefvarChoice[])content_.toArray(array));
    }

    /**
     * Sets the IEE2RDefvarChoice property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IEE2RDefvarChoice[] content) {
        this.content_.clear();
        this.content_.addAll(java.util.Arrays.asList(content));
    }

    /**
     * Sets the IEE2RDefvarChoice property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IEE2RDefvarChoice content) {
        this.content_.clear();
        this.content_.add(content);
    }

    /**
     * Adds the IEE2RDefvarChoice property <b>content</b>.
     *
     * @param content
     */
    public final void addContent(IEE2RDefvarChoice content) {
        this.content_.add(content);
    }

    /**
     * Gets number of the IEE2RDefvarChoice property <b>content</b>.
     *
     * @return int
     */
    public final int getContentCount() {
        return (content_.size());
    }

    /**
     * Gets the IEE2RDefvarChoice property <b>content</b> by index.
     *
     * @param index
     * @return IEE2RDefvarChoice
     */
    public final IEE2RDefvarChoice getContent(int index) {
        return ((IEE2RDefvarChoice)content_.get(index));
    }

    /**
     * Sets the IEE2RDefvarChoice property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public final void setContent(int index, IEE2RDefvarChoice content) {
        this.content_.set(index, content);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<defvar");
        if (id_ != null) {
            buffer.append(" id=\"");
            buffer.append(URelaxer.escapeAttrQuot(getId()));
            buffer.append("\"");
        }
        buffer.append(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IEE2RDefvarChoice value = (IEE2RDefvarChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</defvar>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<defvar");
        if (id_ != null) {
            buffer.print(" id=\"");
            buffer.print(URelaxer.escapeAttrQuot(getId()));
            buffer.print("\"");
        }
        buffer.print(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IEE2RDefvarChoice value = (IEE2RDefvarChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</defvar>");
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>EE2RDefvar</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "defvar")) {
            return (false);
        }
        RStack target = new RStack(element);
        while (!target.isEmptyElement()) {
            if (EE2RTag.isMatchHungry(target)) {
                while (EE2RTag.isMatchHungry(target)) {
                }
            } else if (EE2RAttribute.isMatchHungry(target)) {
                while (EE2RAttribute.isMatchHungry(target)) {
                }
            } else if (EE2REnumeration.isMatchHungry(target)) {
                while (EE2REnumeration.isMatchHungry(target)) {
                }
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EE2RDefvar</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EE2RDefvar</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
