package jp.sourceforge.projects.ee2e.core.dedit;


import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;
import org.eclipse.core.filebuffers.manipulation.ContainerCreator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

/**
 * @see http://graze.at.infoseek.co.jp/plugin/
 */
public class DFileDocumentProvider extends FileDocumentProvider {
    private static final String CHARSET_UTF_8 = "UTF-8";
    /**
     * 
     */
    public DFileDocumentProvider() {
        super();
    }
    public String getEncoding(Object element) {
        return CHARSET_UTF_8;
    }

    private static String ascii2native(String srcStr){
        StringBuffer dstStrBuf = new StringBuffer();
        for(int i = 0; i < srcStr.length(); i++){
            if(srcStr.charAt(i) != '\\'){
                dstStrBuf.append(srcStr.charAt(i));
                continue;
            }
            i++;
            if(i >= srcStr.length()){
                break;
            }
            if(srcStr.charAt(i) != 'u'){
                dstStrBuf.append('\\').append(srcStr.charAt(i));
                continue;
            }
            i++;
            String escStr = srcStr.substring(i, i+4);
            dstStrBuf.append((char)Integer.parseInt(escStr, 16));
            i += 3;
        }
        return dstStrBuf.toString();
    }
    /* (non-Javadoc)
     * @see org.eclipse.ui.editors.text.StorageDocumentProvider#setDocumentContent(org.eclipse.jface.text.IDocument, org.eclipse.ui.IEditorInput, java.lang.String)
     */
    protected boolean setDocumentContent(
        IDocument document,
        IEditorInput editorInput,
        String encoding)
        throws CoreException {
        //      System.out.println(encoding);
        if (editorInput instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput) editorInput).getFile();
            Document doc = new Document();
            super.setDocumentContent(
                doc,
                file.getContents(false),
                encoding);
            String srcStr = doc.get();
            String dstStr = ascii2native(srcStr);
            document.set(dstStr);
            return true;
        }
        return super.setDocumentContent(document, editorInput, encoding);
    }
    /* (non-Javadoc)
     * @see org.eclipse.ui.texteditor.AbstractDocumentProvider#doSaveDocument(org.eclipse.core.runtime.IProgressMonitor, java.lang.Object, org.eclipse.jface.text.IDocument, boolean)
     */
    protected void doSaveDocument(
        IProgressMonitor monitor,
        Object element,
        IDocument document,
        boolean overwrite)
        throws CoreException {
        if (element instanceof IFileEditorInput) {

            IFileEditorInput input= (IFileEditorInput) element;
            String encoding= null;
            try {
                FileInfo info= (FileInfo) getElementInfo(element);
                IFile file= input.getFile();
                encoding = CHARSET_UTF_8;

                byte[] bytes= document.get().getBytes(encoding);
                InputStream stream = new ByteArrayInputStream(bytes);
                if (file.exists()) {

                    if (info != null && !overwrite)
                        checkSynchronizationState(info.fModificationStamp, file);

                    // inform about the upcoming content change
                    fireElementStateChanging(element);
                    try {
                        file.setContents(stream, overwrite, true, monitor);
                    } catch (CoreException x) {
                        // inform about failure
                        fireElementStateChangeFailed(element);
                        throw x;
                    } catch (RuntimeException x) {
                        // inform about failure
                        fireElementStateChangeFailed(element);
                        throw x;
                    }

                    // If here, the editor state will be flipped to "not dirty".
                    // Thus, the state changing flag will be reset.

                    if (info != null) {

                        ResourceMarkerAnnotationModel model= (ResourceMarkerAnnotationModel) info.fModel;
                        model.updateMarkers(info.fDocument);

                        info.fModificationStamp= computeModificationStamp(file);
                    }

                } else {
                    ContainerCreator creator = new ContainerCreator(file.getWorkspace(), file.getParent().getFullPath());
                    creator.createContainer(new SubProgressMonitor(monitor, 1000));
                    file.create(stream, false, new SubProgressMonitor(monitor, 1000));
                }

            } catch (UnsupportedEncodingException x) {
                /*EMPTY*/
            }
        } else {
            super.doSaveDocument(monitor, element, document, overwrite);
        }

    }
}