/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.typeset;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class EE2EReasonedFile {
    private int lineNumber;

    public IFile getFile(String selectString, File parent) throws PartInitException {
        int extPos;
        if (selectString == null || selectString.equals("")) {
            throw new PartInitException("No region!");
        }
        if (this.isCheckNumber(0, selectString)) {
            IFileEditorInput editorInput = this.getIFileEditorInput();
            return editorInput.getFile();
        }
        if (parent == null) {
            parent = new File(".");
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < selectString.length()) {
            char ch = selectString.charAt(i);
            if (ch == '$' || ch == '(' || ch == ')' || ch == '{' || ch == '}' || ch == '[' || ch == ']' || ch == '*' || ch == '\"' || ch == '\'' || ch == '!' || ch == ':' && !this.checkColonFolder(buffer.toString()) || ch == ';') {
                if (buffer.length() > 0) {
                    break;
                }
            } else if (ch == '=') {
                buffer = new StringBuffer();
            } else {
                if (ch == '\t' || ch == '\n' || ch == '\r' || ch == '#' || ch == '?' || ch == '&') break;
                buffer.append(ch);
            }
            ++i;
        }
        boolean flag = false;
        int limmit = -1;
        int i2 = 0;
        while (i2 < buffer.length()) {
            if (buffer.charAt(i2) != ' ') break;
            limmit = i2++;
        }
        if (limmit >= 0) {
            buffer = buffer.replace(0, limmit + 1, "");
        }
        limmit = buffer.length();
        i2 = buffer.length() - 1;
        while (i2 > 0) {
            if (buffer.charAt(i2) != ' ') break;
            flag = true;
            limmit = i2--;
        }
        String string = flag ? buffer.substring(0, limmit) : buffer.toString();
        if (parent != null && string != null && string.indexOf(".") < 0 && 1 < (extPos = parent.getName().lastIndexOf("."))) {
            string = String.valueOf(string) + parent.getName().substring(extPos);
        }
        return this.getFileReal(string, parent);
    }

    public boolean checkColonFolder(String string) {
        if (string == null || string.length() <= 0) {
            return false;
        }
        return string.length() == 1 || string.equals("http") || string.equals("ftp");
    }

    protected IFile getFileReal(String string, File parent) throws PartInitException {
        StringBuffer errorMessage = new StringBuffer();
        IFile anserFile = this.getFileURL(string, errorMessage);
        if (anserFile != null) {
            return anserFile;
        }
        anserFile = this.getFileOneMoreChance(string, parent, errorMessage);
        if (anserFile != null) {
            return anserFile;
        }
        String nextString = string;
        File workFile = new File(string);
        nextString = workFile.getName();
        if (!string.equals(nextString) && (anserFile = this.getFileOneMoreChance(nextString, parent, errorMessage)) != null) {
            return anserFile;
        }
        if ((parent = parent.getParentFile()) == null) {
            parent = new File(".");
        }
        if ((anserFile = this.getSearchFile(nextString, parent, 5)) != null) {
            return anserFile;
        }
        if ((parent = parent.getParentFile()) != null && (anserFile = this.getSearchFile(nextString, parent, 4)) != null) {
            return anserFile;
        }
        throw new PartInitException("Not found!!\n" + errorMessage.toString());
    }

    protected IFile getFileURL(String string, StringBuffer errorMessage) {
        Path appendPath;
        String urlToString;
        IWorkspace iWorkSpase = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkSpase.getRoot();
        int limmit = 0;
        try {
            URL url = new URL(string);
            urlToString = url.getFile();
        }
        catch (MalformedURLException malformedURLException) {
            urlToString = string;
        }
        boolean flag = false;
        int i = 0;
        while (i < urlToString.length()) {
            limmit = i;
            if (urlToString.charAt(i) != '/') break;
            flag = true;
            ++i;
        }
        if (flag) {
            urlToString = urlToString.substring(limmit);
        }
        if (urlToString == null) {
            return null;
        }
        try {
            appendPath = new Path(new File(urlToString).getCanonicalPath());
        }
        catch (IOException iOException) {
            appendPath = new Path(urlToString);
        }
        IFile anserFile = iWorkspaceRoot.getFileForLocation((IPath)appendPath);
        errorMessage.append(String.valueOf(appendPath.toFile().toString()) + "\n");
        if (anserFile != null && anserFile.exists()) {
            return anserFile;
        }
        IWorkspace workSpace = ResourcesPlugin.getWorkspace();
        File file = workSpace.getRoot().getLocation().toFile();
        file = new File(file, urlToString);
        try {
            appendPath = new Path(appendPath.toFile().getCanonicalPath());
        }
        catch (IOException iOException) {
            appendPath = new Path(file.toString());
        }
        anserFile = iWorkspaceRoot.getFileForLocation((IPath)appendPath);
        errorMessage.append(String.valueOf(appendPath.toFile().toString()) + "\n");
        if (anserFile != null && anserFile.exists()) {
            return anserFile;
        }
        return null;
    }

    protected IFile getFileOneMoreChance(String string, File parent, StringBuffer errorMessage) {
        Path appendPath = new Path(string);
        IWorkspace iWorkSpase = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkSpase.getRoot();
        IFile anserFile = iWorkspaceRoot.getFileForLocation((IPath)appendPath);
        errorMessage.append(String.valueOf(appendPath.toFile().toString()) + "\n");
        if (anserFile != null && anserFile.exists()) {
            return anserFile;
        }
        if (parent != null) {
            File base = new File(parent, string);
            try {
                appendPath = new Path(base.getCanonicalPath());
            }
            catch (IOException iOException) {
                appendPath = new Path(base.toString());
            }
            anserFile = iWorkspaceRoot.getFileForLocation((IPath)appendPath);
            errorMessage.append(String.valueOf(appendPath.toFile().toString()) + "\n");
            if (anserFile != null && anserFile.exists()) {
                return anserFile;
            }
        }
        File file = iWorkspaceRoot.getLocation().toFile();
        file = new File(file, string);
        try {
            appendPath = new Path(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            appendPath = new Path(file.toString());
        }
        anserFile = iWorkspaceRoot.getFileForLocation((IPath)appendPath);
        errorMessage.append(String.valueOf(appendPath.toFile().toString()) + "\n");
        if (anserFile != null && anserFile.exists()) {
            return anserFile;
        }
        anserFile = this.getActiveFile(string);
        errorMessage.append(String.valueOf(appendPath.toFile().toString()) + "\n");
        if (anserFile != null && anserFile.exists()) {
            return anserFile;
        }
        IFileEditorInput iFileEditorInput = this.getIFileEditorInput();
        if (iFileEditorInput != null) {
            IContainer iContainer = iFileEditorInput.getFile().getParent();
            String[] segments = iContainer.getFullPath().segments();
            String relativityTarget = iWorkspaceRoot.getLocation().toFile().toString();
            int i = 0;
            while (i < segments.length) {
                relativityTarget = String.valueOf(relativityTarget) + File.separator + segments[i];
                file = new File(relativityTarget);
                file = new File(file, string);
                try {
                    appendPath = new Path(file.getCanonicalPath());
                }
                catch (IOException iOException) {
                    appendPath = new Path(file.toString());
                }
                try {
                    anserFile = iWorkspaceRoot.getFileForLocation((IPath)appendPath);
                    errorMessage.append(String.valueOf(appendPath.toFile().toString()) + "\n");
                    if (anserFile != null && anserFile.exists()) {
                        return anserFile;
                    }
                }
                catch (RuntimeException aException) {
                    EE2EDebug.printf(5, "path=" + relativityTarget + " e=\"" + aException.getMessage() + "\"");
                }
                ++i;
            }
        }
        return null;
    }

    protected IFile getSearchFile(String string, File parent, int deep) {
        if (deep <= 0) {
            return null;
        }
        if (!parent.isDirectory()) {
            return null;
        }
        File[] list = parent.listFiles();
        IWorkspace iWorkSpase = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkSpase.getRoot();
        int i = 0;
        while (i < list.length) {
            IFile anserFile;
            if (list[i].isFile()) {
                String ans = list[i].getName();
                if (ans.equalsIgnoreCase(string)) {
                    Path appendPath = new Path(list[i].toString());
                    try {
                        anserFile = iWorkspaceRoot.getFileForLocation((IPath)appendPath);
                        if (anserFile != null && anserFile.exists()) {
                            return anserFile;
                        }
                    }
                    catch (RuntimeException runtimeException) {}
                }
            } else if (list[i].isDirectory() && (anserFile = this.getSearchFile(string, list[i], deep - 1)) != null && anserFile.exists()) {
                return anserFile;
            }
            ++i;
        }
        return null;
    }

    protected boolean isCheckNumber(int point, String selectString) {
        this.setLineNumber(0);
        int i = point;
        while (i < selectString.length()) {
            if (' ' != selectString.charAt(i) && '\t' != selectString.charAt(i)) {
                if ('0' > selectString.charAt(i) || selectString.charAt(i) > '9') break;
                this.setLineNumber(this.getLineNumber() * 10 + selectString.charAt(i) - 48);
            }
            ++i;
        }
        return this.getLineNumber() > 0;
    }

    protected IFile getActiveFile(String target) {
        IFileEditorInput fileInput = this.getIFileEditorInput();
        if (fileInput == null) {
            return null;
        }
        File file = fileInput.getFile().getParent().getLocation().toFile();
        file = new File(file, target);
        Path appendPath = new Path(file.toString());
        IWorkspace iWorkSpase = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkSpase.getRoot();
        IFile anserFile = iWorkspaceRoot.getFileForLocation((IPath)appendPath);
        return anserFile;
    }

    protected IFileEditorInput getIFileEditorInput() {
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (activeEditor == null) {
            return null;
        }
        IEditorInput editorInput = activeEditor.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            return null;
        }
        return (IFileEditorInput)editorInput;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }
}

