/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.relax;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.projects.ee2e.core.relax.EE2RAttribute;
import jp.sourceforge.projects.ee2e.core.relax.EE2REnumeration;
import jp.sourceforge.projects.ee2e.core.relax.EE2RTag;
import jp.sourceforge.projects.ee2e.core.relax.IEE2RDefvarChoice;
import jp.sourceforge.projects.ee2e.core.relax.RStack;
import jp.sourceforge.projects.ee2e.core.relax.UJAXP;
import jp.sourceforge.projects.ee2e.core.relax.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EE2RDefvar
implements Serializable {
    private String id_;
    private List content_ = new ArrayList();

    public EE2RDefvar() {
    }

    public EE2RDefvar(RStack stack) {
        this.setup(stack);
    }

    public EE2RDefvar(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public EE2RDefvar(Element element) {
        this.setup(element);
    }

    public EE2RDefvar(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public EE2RDefvar(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public EE2RDefvar(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public EE2RDefvar(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public EE2RDefvar(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public EE2RDefvar(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.setup(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.id_ = URelaxer.getAttributePropertyAsString(element, "id");
        this.content_.clear();
        while (!stack.isEmptyElement()) {
            if (EE2RTag.isMatch(stack)) {
                this.addContent(new EE2RTag(stack));
                continue;
            }
            if (EE2RAttribute.isMatch(stack)) {
                this.addContent(new EE2RAttribute(stack));
                continue;
            }
            if (!EE2REnumeration.isMatch(stack)) break;
            this.addContent(new EE2REnumeration(stack));
        }
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("defvar");
        if (this.id_ != null) {
            URelaxer.setAttributePropertyByString(element, "id", this.id_);
        }
        int size = this.content_.size();
        int i = 0;
        while (i < size) {
            IEE2RDefvarChoice value = (IEE2RDefvarChoice)this.content_.get(i);
            value.makeElement(element);
            ++i;
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(uri));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(url));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(in));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(is));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(reader));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getId() {
        return this.id_;
    }

    public final void setId(String id) {
        this.id_ = id;
    }

    public final IEE2RDefvarChoice[] getContent() {
        IEE2RDefvarChoice[] array = new IEE2RDefvarChoice[this.content_.size()];
        return this.content_.toArray(array);
    }

    public final void setContent(IEE2RDefvarChoice[] content) {
        this.content_.clear();
        this.content_.addAll((Collection)Arrays.asList(content));
    }

    public final void setContent(IEE2RDefvarChoice content) {
        this.content_.clear();
        this.content_.add(content);
    }

    public final void addContent(IEE2RDefvarChoice content) {
        this.content_.add(content);
    }

    public final int getContentCount() {
        return this.content_.size();
    }

    public final IEE2RDefvarChoice getContent(int index) {
        return (IEE2RDefvarChoice)this.content_.get(index);
    }

    public final void setContent(int index, IEE2RDefvarChoice content) {
        this.content_.set(index, content);
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<defvar");
        if (this.id_ != null) {
            buffer.append(" id=\"");
            buffer.append(URelaxer.escapeAttrQuot(this.getId()));
            buffer.append("\"");
        }
        buffer.append(">");
        int size = this.content_.size();
        int i = 0;
        while (i < size) {
            IEE2RDefvarChoice value = (IEE2RDefvarChoice)this.content_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.append("</defvar>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<defvar");
        if (this.id_ != null) {
            buffer.print(" id=\"");
            buffer.print(URelaxer.escapeAttrQuot(this.getId()));
            buffer.print("\"");
        }
        buffer.print(">");
        int size = this.content_.size();
        int i = 0;
        while (i < size) {
            IEE2RDefvarChoice value = (IEE2RDefvarChoice)this.content_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.print("</defvar>");
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "defvar")) {
            return false;
        }
        RStack target = new RStack(element);
        while (!target.isEmptyElement()) {
            if (EE2RTag.isMatchHungry(target)) {
                while (EE2RTag.isMatchHungry(target)) {
                }
                continue;
            }
            if (EE2RAttribute.isMatchHungry(target)) {
                while (EE2RAttribute.isMatchHungry(target)) {
                }
                continue;
            }
            if (!EE2REnumeration.isMatchHungry(target)) break;
            while (EE2REnumeration.isMatchHungry(target)) {
            }
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return EE2RDefvar.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (EE2RDefvar.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

