/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.indent;

import jp.sourceforge.projects.ee2e.core.indent.EE2EDocument;
import jp.sourceforge.projects.ee2e.core.indent.EE2EIndentException;

public final class EE2ELispBase {
    private static EE2ELispBase instance;

    private EE2ELispBase() {
    }

    public static EE2ELispBase get() {
        if (instance == null) {
            instance = new EE2ELispBase();
        }
        return instance;
    }

    public int beginningOfLine(int offset, EE2EDocument document) throws EE2EIndentException {
        if (offset <= 0) {
            return 0;
        }
        if ((offset = this.findCharsBackward(offset - 1, "\r\n", document)) <= 0) {
            return 0;
        }
        if (document.getLength() <= ++offset) {
            offset = document.getLength() - 1;
        }
        return offset;
    }

    public int endOfLine(int offset, EE2EDocument document) throws EE2EIndentException {
        offset = this.findCharsForward(offset, "\r\n", document);
        if (document.getLength() < offset) {
            offset = document.getLength();
        }
        if (--offset < 0) {
            offset = 0;
        }
        return offset;
    }

    public int findCharsBackward(int offset, String ans, EE2EDocument document) throws EE2EIndentException {
        if (document.getLength() <= offset) {
            offset = document.getLength() - 1;
        }
        while (offset > 0) {
            char dChar = document.getChar(offset);
            int i = 0;
            while (i < ans.length()) {
                if (dChar == ans.charAt(i)) {
                    return offset;
                }
                ++i;
            }
            --offset;
        }
        return offset;
    }

    public int findCharsForward(int offset, String ans, EE2EDocument document) throws EE2EIndentException {
        return this.findCharsForward(offset, ans, document, document.getLength());
    }

    public int findCharsForward(int offset, String ans, EE2EDocument document, int limmit) throws EE2EIndentException {
        while (offset < limmit) {
            char dChar = document.getChar(offset);
            int i = 0;
            while (i < ans.length()) {
                if (dChar == ans.charAt(i)) {
                    return offset;
                }
                ++i;
            }
            ++offset;
        }
        return offset;
    }

    public int skipCharsBackward(int offset, String ans, EE2EDocument document) throws EE2EIndentException {
        return this.skipCharsBackward(offset, ans, document, 0);
    }

    public int skipCharsBackward(int offset, String ans, EE2EDocument document, int limit) throws EE2EIndentException {
        while (limit < offset) {
            char dChar = document.getChar(offset);
            int i = 0;
            while (i < ans.length()) {
                if (dChar == ans.charAt(i)) break;
                ++i;
            }
            if (ans.length() <= i) break;
            --offset;
        }
        return offset;
    }

    public int skipCharsForward(int offset, String ans, EE2EDocument document) throws EE2EIndentException {
        return this.skipCharsForward(offset, ans, document, document.getLength());
    }

    public int skipCharsForward(int offset, String ans, EE2EDocument document, int limmit) throws EE2EIndentException {
        while (offset < limmit) {
            char dChar = document.getChar(offset);
            int i = 0;
            while (i < ans.length()) {
                if (dChar == ans.charAt(i)) break;
                ++i;
            }
            if (ans.length() <= i) break;
            ++offset;
        }
        return offset - 1;
    }

    public void indentTo(int offset, int size, EE2EDocument document) throws EE2EIndentException {
        int begin;
        if (size < 0) {
            size = 0;
        }
        int realSize = 0;
        int len = 0;
        boolean tabNotUsedFlag = true;
        int i = begin = this.beginningOfLine(offset, document);
        while (i < document.getLength()) {
            if (document.getChar(i) == ' ') {
                ++realSize;
                ++len;
            } else {
                if (document.getChar(i) != '\t') break;
                ++realSize;
                len += 4;
                tabNotUsedFlag = false;
            }
            ++i;
        }
        if (size == len && tabNotUsedFlag) {
            return;
        }
        StringBuffer buff = new StringBuffer();
        int i2 = 0;
        while (i2 < size) {
            buff.append(' ');
            ++i2;
        }
        document.replace(begin, realSize, buff.toString());
    }

    public int indentLen(int offset, EE2EDocument document) throws EE2EIndentException {
        int begin = this.beginningOfLine(offset, document);
        int len = 0;
        int i = begin;
        while (i < document.getLength()) {
            if (document.getChar(i) == ' ') {
                ++len;
            } else {
                if (document.getChar(i) != '\t') break;
                len += 4;
            }
            ++i;
        }
        return len;
    }

    public boolean lookingAt(int argumentOffset, String target, EE2EDocument document) throws EE2EIndentException {
        int offset = argumentOffset;
        int i = 0;
        while (i < target.length()) {
            char documentChar;
            if (document.getLength() <= offset + i) {
                return false;
            }
            char targetChar = target.charAt(i);
            if (targetChar != (documentChar = document.getChar(offset + i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

