/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.editors;

import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior;
import jp.sourceforge.projects.ee2e.core.editors.EE2EToolkit;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class EE2EUnTranslateRegion
implements EE2EMenuBehavior {
    public String getText() {
        return String.valueOf(EE2EPlugin.getResourceString("action.untranslateR")) + "(&;)";
    }

    public String getToolTipText() {
        return EE2EPlugin.getResourceString("action.untranslateR.tooltip");
    }

    public void doBehavior(AbstractTextEditor editor, ITextSelection textSelection) throws BadLocationException {
        IDocument document = EE2EToolkit.get().getEditorToDocument(editor);
        String text = textSelection.getText();
        if (textSelection.getLength() <= 0 && text.equals("")) {
            return;
        }
        String oldText = "";
        while (true) {
            int ltInt = text.indexOf("&lt;");
            int gtInt = text.indexOf("&gt;");
            int ampInt = text.indexOf("&amp;");
            int doubleInt = text.indexOf("&quot;");
            if (ltInt < 0 && gtInt < 0 && ampInt < 0) break;
            if (ltInt < 0) {
                ltInt = Integer.MAX_VALUE;
            }
            if (gtInt < 0) {
                gtInt = Integer.MAX_VALUE;
            }
            if (ampInt < 0) {
                ampInt = Integer.MAX_VALUE;
            }
            if (doubleInt < 0) {
                doubleInt = Integer.MAX_VALUE;
            }
            String after = "&lt;";
            String result = "<";
            int min = ltInt;
            if (gtInt < min) {
                min = gtInt;
                after = "&gt;";
                result = ">";
            }
            if (ampInt < min) {
                min = ampInt;
                after = "&amp;";
                result = "&";
            }
            if (doubleInt < min) {
                min = doubleInt;
                after = "&quot;";
                result = "\"";
            }
            oldText = String.valueOf(oldText) + text.substring(0, min);
            oldText = String.valueOf(oldText) + result;
            text = text.substring(min + after.length());
        }
        text = String.valueOf(oldText) + text;
        document.replace(textSelection.getOffset(), textSelection.getLength(), text);
    }
}

