/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.dedit;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.filebuffers.manipulation.ContainerCreator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class DFileDocumentProvider
extends FileDocumentProvider {
    private static final String CHARSET_UTF_8 = "UTF-8";

    public String getEncoding(Object element) {
        return CHARSET_UTF_8;
    }

    private static String ascii2native(String srcStr) {
        StringBuffer dstStrBuf = new StringBuffer();
        int i = 0;
        while (i < srcStr.length()) {
            if (srcStr.charAt(i) != '\\') {
                dstStrBuf.append(srcStr.charAt(i));
            } else {
                if (++i >= srcStr.length()) break;
                if (srcStr.charAt(i) != 'u') {
                    dstStrBuf.append('\\').append(srcStr.charAt(i));
                } else {
                    String escStr = srcStr.substring(++i, i + 4);
                    dstStrBuf.append((char)Integer.parseInt(escStr, 16));
                    i += 3;
                }
            }
            ++i;
        }
        return dstStrBuf.toString();
    }

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        if (editorInput instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)editorInput).getFile();
            Document doc = new Document();
            super.setDocumentContent((IDocument)doc, file.getContents(false), encoding);
            String srcStr = doc.get();
            String dstStr = DFileDocumentProvider.ascii2native(srcStr);
            document.set(dstStr);
            return true;
        }
        return super.setDocumentContent(document, editorInput, encoding);
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        block10: {
            if (element instanceof IFileEditorInput) {
                IFileEditorInput input = (IFileEditorInput)element;
                String encoding = null;
                try {
                    FileDocumentProvider.FileInfo info = (FileDocumentProvider.FileInfo)this.getElementInfo(element);
                    IFile file = input.getFile();
                    encoding = CHARSET_UTF_8;
                    byte[] bytes = document.get().getBytes(encoding);
                    ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                    if (file.exists()) {
                        if (info != null && !overwrite) {
                            this.checkSynchronizationState(info.fModificationStamp, (IResource)file);
                        }
                        this.fireElementStateChanging(element);
                        try {
                            file.setContents((InputStream)stream, overwrite, true, monitor);
                        }
                        catch (CoreException x) {
                            this.fireElementStateChangeFailed(element);
                            throw x;
                        }
                        catch (RuntimeException x) {
                            this.fireElementStateChangeFailed(element);
                            throw x;
                        }
                        if (info != null) {
                            ResourceMarkerAnnotationModel model = (ResourceMarkerAnnotationModel)info.fModel;
                            model.updateMarkers(info.fDocument);
                            info.fModificationStamp = this.computeModificationStamp((IResource)file);
                        }
                        break block10;
                    }
                    ContainerCreator creator = new ContainerCreator(file.getWorkspace(), file.getParent().getFullPath());
                    creator.createContainer((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                    file.create((InputStream)stream, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else {
                super.doSaveDocument(monitor, element, document, overwrite);
            }
        }
    }
}

