/*
 * Decompiled with CFR 0.152.
 */
package com.ranfa.lib.io;

import com.ranfa.lib.io.OutputDataStructure;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIO {
    private static Logger logger = LoggerFactory.getLogger(FileIO.class);
    private static final String FILE_NAME_PATTERN = "YYYY-MM-dd-HH-mm-ss";
    private static final String FILE_EXTENSION = ".drs";
    private OutputDataStructure data;

    public FileIO(OutputDataStructure data) {
        this.data = data;
    }

    public void write() throws IOException {
        StringBuilder builder = new StringBuilder(new SimpleDateFormat(FILE_NAME_PATTERN).format(new Date()));
        builder.append(FILE_EXTENSION);
        ObjectOutputStream outStream = new ObjectOutputStream(new FileOutputStream(builder.toString()));
        outStream.writeObject(this.data);
        outStream.close();
    }

    public static OutputDataStructure read(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            OutputDataStructure structure = (OutputDataStructure)objectInputStream.readObject();
            objectInputStream.close();
            return structure;
        }
        catch (IOException | ClassNotFoundException e) {
            logger.error("Exception while reading objects", (Throwable)e);
            return null;
        }
    }
}

