/*
 * Decompiled with CFR 0.152.
 */
package com.ranfa.lib.calc;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PRPCalc {
    private final Logger logger = LoggerFactory.getLogger(PRPCalc.class);
    private static final String PRP_STORAGE_FILE_PATH = "generated/prp.json";
    private static final BigDecimal THAUSAND = BigDecimal.valueOf(10000L);
    private List<Integer> TotalPRPList;
    private int TotalPRP;

    public PRPCalc() {
        if (Files.notExists(Paths.get(PRP_STORAGE_FILE_PATH, new String[0]), new LinkOption[0])) {
            this.generateEmptyPRPFile();
        }
        TypeReference<List<Integer>> typeref = new TypeReference<List<Integer>>(){};
        try {
            this.TotalPRPList = (List)new ObjectMapper().readValue(Paths.get(PRP_STORAGE_FILE_PATH, new String[0]).toFile(), (TypeReference)typeref);
        }
        catch (IOException e) {
            this.logger.error("Couldn't read prp file from disk.", (Throwable)e);
        }
        this.TotalPRP = this.calcCurrentTotal();
    }

    public boolean generateEmptyPRPFile() {
        if (Files.notExists(Paths.get("generated", new String[0]), new LinkOption[0])) {
            try {
                Files.createDirectory(Paths.get("generated", new String[0]), new FileAttribute[0]);
                Files.createFile(Paths.get(PRP_STORAGE_FILE_PATH, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.logger.error("cannot make prp file.", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public int calcCurrentTotal() {
        int res = 0;
        for (int val : this.TotalPRPList) {
            res += val;
        }
        return res;
    }

    public int getTotalPRP() {
        return this.TotalPRP;
    }

    public static int calcPRPFromScore(int score) {
        BigDecimal scoreDecimal = BigDecimal.valueOf(score);
        return scoreDecimal.divide(THAUSAND, RoundingMode.DOWN).intValueExact();
    }
}

