/*
 * Decompiled with CFR 0.152.
 */
package com.ranfa.lib.calc;

import com.ranfa.lib.concurrent.CountedThreadFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FanCalc {
    private static final Logger logger = LoggerFactory.getLogger(FanCalc.class);
    private static final ExecutorService async = Executors.newCachedThreadPool(new CountedThreadFactory(() -> "DRS", "FanCalcThread", false));

    public static int fan(int score, int room, int center, int produce, int premium) {
        BigDecimal toPercent = new BigDecimal(100);
        BigDecimal res = new BigDecimal(0);
        BigDecimal roomPercent = new BigDecimal(room).divide(toPercent);
        BigDecimal centerPercent = new BigDecimal(center).divide(toPercent);
        BigDecimal producePercent = new BigDecimal(produce).divide(toPercent);
        BigDecimal premiumPercent = new BigDecimal(premium).divide(toPercent);
        BigDecimal corrections = new BigDecimal(-1).add(roomPercent).add(centerPercent);
        res = res.add(new BigDecimal(score)).multiply(corrections).divide(new BigDecimal("1000"));
        res = res.setScale(0, RoundingMode.UP);
        BigDecimal resCorrected = res.multiply(producePercent);
        resCorrected = resCorrected.setScale(0, RoundingMode.UP);
        BigDecimal resPremiumed = resCorrected.multiply(premiumPercent);
        return (resPremiumed = resPremiumed.setScale(0, RoundingMode.UP)).compareTo(BigDecimal.ZERO) == 0 ? 0 : Integer.parseInt(resPremiumed.toString());
    }

    public static CompletableFuture<Integer> fanAsync(int score, int room, int center, int produce, int premium) {
        return CompletableFuture.supplyAsync(() -> FanCalc.fan(score, room, center, produce, premium), async);
    }

    public static CompletableFuture<Integer> scoreAsync(int fan, int multiplier, int room, int center, int produce, int premium) {
        return CompletableFuture.supplyAsync(() -> FanCalc.score(fan, multiplier, room, center, produce, premium), async);
    }

    private static int score(int fan, int multiplier, int room, int center, int produce, int premium) {
        BigDecimal goalFan = new BigDecimal(fan).divide(new BigDecimal(multiplier), 0, RoundingMode.UP);
        AtomicInteger result = new AtomicInteger(0);
        AtomicBoolean flag = new AtomicBoolean(false);
        logger.info("Started to calculate score at dedicated thread.");
        while (!flag.get()) {
            int localFan = FanCalc.fan(result.incrementAndGet(), room, center, produce, premium) * 5;
            if (goalFan.compareTo(new BigDecimal(localFan)) > 0) continue;
            flag.set(true);
        }
        logger.info("Finished calculating. Estimated Fan value : {}", (Object)result.intValue());
        return Integer.parseInt(result.toString());
    }
}

