/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.ranfa.lib.handler.CrashHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CrashReportTest {
    private static final String INPUT_DIR = "Crash-Report";
    private static List<Path> before;

    @BeforeClass
    public static void flushFolder() throws IOException {
        if (Files.notExists(Paths.get(INPUT_DIR, new String[0]), new LinkOption[0])) {
            Files.createDirectory(Paths.get(INPUT_DIR, new String[0]), new FileAttribute[0]);
        }
        before = Arrays.asList((Path[])Files.list(Paths.get(INPUT_DIR, new String[0])).toArray(Path[]::new));
    }

    @Test
    public void generateSystemReportTest() {
        CrashHandler handle = new CrashHandler();
        Assert.assertNotNull((Object)handle.outSystemInfo());
    }

    @Test
    public void generateCrashReportTest() {
        CrashHandler handle = new CrashHandler(new RuntimeException());
        Assert.assertEquals((Object)"Unexpected Error", (Object)handle.getDescription());
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)handle.getEstimateExitCode());
        Assert.assertEquals(handle.getThrowable().getClass(), RuntimeException.class);
    }

    @AfterClass
    public static void deleteReport() throws IOException {
        List<Path> after = Arrays.asList((Path[])Files.list(Paths.get(INPUT_DIR, new String[0])).toArray(Path[]::new));
        after.removeAll(before);
        after.stream().forEach(t -> {
            try {
                Files.delete(t);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }
}

